/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.shaders.FogShape;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.srrapero720.chloride.Chloride;
import me.srrapero720.chloride.impl.Borderless;
import me.srrapero720.chloride.impl.ChunkFade;
import me.srrapero720.chloride.impl.Darkness;
import me.srrapero720.chloride.impl.LeavesCulling;
import me.srrapero720.chloride.impl.Overlay;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="chloride", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ChlorideConfig {
    public static final Marker IT = MarkerManager.getMarker((String)"Config");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().registerTypeAdapter(ResourceLocation.class, (Object)new ChlorideResourceLocationSerial()).registerTypeAdapter(new TypeToken<List<ResourceLocation>>(){}.getType(), (Object)new ListResourceLocationAdapter()).registerTypeAdapter(ChlorideConfig.class, (Object)new ChlorideConfigSerial()).create();
    private static final ChlorideConfig DUMMY = new ChlorideConfig();
    private static File configFile;
    @ConfigField
    public static boolean modpackMode;
    @ConfigField
    public static Borderless.Mode fullScreen;
    @ConfigField
    public static Overlay.FPS fpsDisplayMode;
    @ConfigField
    public static Overlay.FPSAlign fpsDisplayAlign;
    @ConfigField
    public static Overlay.FPSVAlign fpsDisplayVAlign;
    @ConfigField
    public static Overlay.FPSDetails fpsDisplaySystemMode;
    @ConfigField
    public static int fpsDisplayMargin;
    @ConfigField
    public static int fpsDisplayVMargin;
    @ConfigField
    public static boolean fpsDisplayShadow;
    @ConfigField
    public static boolean fog;
    @ConfigField
    public static boolean blueBand;
    @ConfigField
    public static boolean customFog;
    @ConfigField
    public static int fogStart;
    @ConfigField
    public static int fogEnd;
    @ConfigField
    public static FogShape fogShape;
    @ConfigField
    public static int cloudsHeight;
    @ConfigField
    public static boolean entityNametagRendering;
    @ConfigField
    public static boolean playerNametagRendering;
    @ConfigField
    public static boolean itemNametagRendering;
    @ConfigField
    public static ChunkFade.Speed chunkFadeSpeed;
    @ConfigField
    public static Darkness.Level darknessMode;
    @ConfigField
    public static boolean darknessOnOverworld;
    @ConfigField
    public static boolean darknessOnNether;
    @ConfigField
    public static double darknessNetherFogBright;
    @ConfigField
    public static boolean darknessOnEnd;
    @ConfigField
    public static double darknessEndFogBright;
    @ConfigField
    public static boolean darknessByDefault;
    @ConfigField
    public static List<ResourceLocation> darknessDimensionWhiteList;
    @ConfigField
    public static boolean darknessOnNoSkyLight;
    @ConfigField
    public static boolean darknessBlockLightOnly;
    @ConfigField
    public static boolean darknessAffectedByMoonPhase;
    @ConfigField
    public static double darknessNewMoonBright;
    @ConfigField
    public static double darknessFullMoonBright;
    @ConfigField
    public static boolean hideJREMI;
    @ConfigField
    public static boolean fontShadows;
    @ConfigField
    public static LeavesCulling.LeavesCullingMode leavesCulling;
    @ConfigField
    public static boolean fastChests;
    @ConfigField
    public static boolean fastBeds;
    @ConfigField
    public static boolean rainParticles;
    @ConfigField
    public static boolean rainDropParticles;
    @ConfigField
    public static boolean crackingBlockParticles;
    @ConfigField
    public static boolean destroyedBlockParticles;
    @ConfigField
    public static List<ResourceLocation> disabledParticles;
    @ConfigField
    public static boolean tileEntityDistanceCulling;
    @ConfigField
    public static int tileEntityCullingDistanceX;
    @ConfigField
    public static int tileEntityCullingDistanceY;
    @ConfigField
    public static boolean entityDistanceCulling;
    @ConfigField
    public static int entityCullingDistanceX;
    @ConfigField
    public static int entityCullingDistanceY;
    @ConfigField
    public static boolean monsterDistanceCulling;
    @ConfigField
    public static int monsterCullingDistanceX;
    @ConfigField
    public static int monsterCullingDistanceY;
    @ConfigField
    public static List<ResourceLocation> entityWhitelist;
    @ConfigField
    public static List<ResourceLocation> monsterWhitelist;
    @ConfigField
    public static List<ResourceLocation> tileEntityWhitelist;
    @ConfigField
    public static Borderless.AttachMode borderlessAttachModeF11;
    @ConfigField
    public static boolean fastLanguageReload;
    @ConfigField
    public static boolean enableZoom;
    @ConfigField
    public static double maxZoom;

    public static List<ResourceLocation> toId(String ... ids) {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        for (String id : ids) {
            if (id.endsWith(":*")) {
                id = id.replace(":*", ":all");
            }
            result.add(ResourceLocation.m_135820_((String)id));
        }
        return result;
    }

    static void load(Path configPath) {
        configFile = configPath.resolve("chloride-client.json").toFile();
        if (!configFile.exists()) {
            ChlorideConfig.write();
        } else {
            ChlorideConfig.read();
            ChlorideConfig.write();
        }
    }

    public static void write() {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(configFile));){
            out.write(GSON.toJson((Object)DUMMY).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            Chloride.LOGGER.error("Cannot write file", (Throwable)e);
        }
    }

    private static void read() {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(configFile));){
            GSON.fromJson(new String(in.readAllBytes(), StandardCharsets.UTF_8), ChlorideConfig.class);
        }
        catch (Exception e) {
            Chloride.LOGGER.error("Cannot read file, writting to defaults", (Throwable)e);
            ChlorideConfig.write();
        }
    }

    static {
        modpackMode = false;
        fullScreen = Borderless.Mode.WINDOWED;
        fpsDisplayMode = Overlay.FPS.ADVANCED;
        fpsDisplayAlign = Overlay.FPSAlign.LEFT;
        fpsDisplayVAlign = Overlay.FPSVAlign.TOP;
        fpsDisplaySystemMode = Overlay.FPSDetails.OFF;
        fpsDisplayMargin = 12;
        fpsDisplayVMargin = 12;
        fpsDisplayShadow = false;
        fog = true;
        blueBand = true;
        customFog = true;
        fogStart = 0;
        fogEnd = 192;
        fogShape = FogShape.CYLINDER;
        cloudsHeight = 192;
        entityNametagRendering = true;
        playerNametagRendering = true;
        itemNametagRendering = true;
        chunkFadeSpeed = ChunkFade.Speed.SLOW;
        darknessMode = Darkness.Level.VANILLA;
        darknessOnOverworld = true;
        darknessOnNether = false;
        darknessNetherFogBright = 0.5;
        darknessOnEnd = false;
        darknessEndFogBright = 0.5;
        darknessByDefault = false;
        darknessDimensionWhiteList = Collections.emptyList();
        darknessOnNoSkyLight = false;
        darknessBlockLightOnly = false;
        darknessAffectedByMoonPhase = true;
        darknessNewMoonBright = 0.0;
        darknessFullMoonBright = 0.25;
        hideJREMI = false;
        fontShadows = true;
        leavesCulling = LeavesCulling.LeavesCullingMode.OFF;
        fastChests = false;
        fastBeds = false;
        rainParticles = true;
        rainDropParticles = true;
        crackingBlockParticles = true;
        destroyedBlockParticles = true;
        disabledParticles = ChlorideConfig.toId(new String[0]);
        tileEntityDistanceCulling = true;
        tileEntityCullingDistanceX = 4096;
        tileEntityCullingDistanceY = 32;
        entityDistanceCulling = true;
        entityCullingDistanceX = 4096;
        entityCullingDistanceY = 32;
        monsterDistanceCulling = false;
        monsterCullingDistanceX = 16384;
        monsterCullingDistanceY = 64;
        entityWhitelist = ChlorideConfig.toId("minecraft:ghast", "minecraft:ender_dragon", "iceandfire:all", "create:all");
        monsterWhitelist = ChlorideConfig.toId(new String[0]);
        tileEntityWhitelist = ChlorideConfig.toId("waterframes:all");
        borderlessAttachModeF11 = Borderless.AttachMode.ATTACH;
        fastLanguageReload = true;
        enableZoom = true;
        maxZoom = 50.0;
    }

    private static final class ChlorideResourceLocationSerial
    implements JsonSerializer<ResourceLocation>,
    JsonDeserializer<ResourceLocation> {
        private ChlorideResourceLocationSerial() {
        }

        public ResourceLocation deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return ResourceLocation.m_135820_((String)jsonElement.getAsString().replace(":*", ":all"));
        }

        public JsonElement serialize(ResourceLocation resourceLocation, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(resourceLocation.toString());
        }
    }

    public static class ListResourceLocationAdapter
    implements JsonSerializer<List<ResourceLocation>>,
    JsonDeserializer<List<ResourceLocation>> {
        public JsonElement serialize(List<ResourceLocation> src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(src.stream().map(ResourceLocation::toString).collect(Collectors.toList()));
        }

        public List<ResourceLocation> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonArray()) {
                throw new JsonParseException("Expected a JSON array for List<ResourceLocation>");
            }
            JsonArray jsonArray = json.getAsJsonArray();
            return jsonArray.asList().stream().map(e -> (ResourceLocation)context.deserialize(e, ResourceLocation.class)).collect(Collectors.toList());
        }
    }

    private static final class ChlorideConfigSerial
    implements JsonSerializer<ChlorideConfig>,
    JsonDeserializer<ChlorideConfig> {
        private ChlorideConfigSerial() {
        }

        public JsonElement serialize(ChlorideConfig src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            for (Field field : ChlorideConfig.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(ConfigField.class)) continue;
                try {
                    field.setAccessible(true);
                    jsonObject.add(field.getName(), context.serialize(field.get(null)));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Error al acceder al campo: " + field.getName(), e);
                }
            }
            return jsonObject;
        }

        public ChlorideConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            for (Field field : ChlorideConfig.class.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ConfigField.class) || !Modifier.isStatic(field.getModifiers())) continue;
                try {
                    JsonElement element = jsonObject.get(field.getName());
                    if (element == null || element.isJsonNull()) continue;
                    field.setAccessible(true);
                    field.set(null, context.deserialize(element, field.getGenericType()));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Error al asignar el valor al campo: " + field.getName(), e);
                }
            }
            return new ChlorideConfig();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ConfigField {
    }
}

