/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.network;

import com.obscuria.obscureapi.ObscureAPI;
import com.obscuria.obscureapi.ObscureAPIClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AnimationStopMessage {
    private final int entity;
    private final byte animation;

    public AnimationStopMessage(int entity, byte animation) {
        this.entity = entity;
        this.animation = animation;
    }

    public AnimationStopMessage(FriendlyByteBuf buffer) {
        this.entity = buffer.readInt();
        this.animation = buffer.readByte();
    }

    public static void buffer(AnimationStopMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entity);
        buffer.writeByte((int)message.animation);
    }

    public static void handler(AnimationStopMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ObscureAPIClient.stopAnimation(message.entity, message.animation)));
        context.get().setPacketHandled(true);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ObscureAPI.addNetworkMessage(AnimationStopMessage.class, AnimationStopMessage::buffer, AnimationStopMessage::new, AnimationStopMessage::handler);
    }
}

