/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.stream.Stream;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.CourierPackageTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CourierPackage
extends BaseEntityBlock
implements ITileEntity<CourierPackageTile>,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<State> STATE = EnumProperty.m_61587_((String)"state", State.class);
    VoxelShape shape_turned = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)7.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    VoxelShape shape = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)7.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public CourierPackage(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_(STATE, (Comparable)((Object)State.SEALED)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof CourierPackageTile) {
            CourierPackageTile courierPackageTile = (CourierPackageTile)blockEntity;
            return courierPackageTile.interact(pPlayer) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof CourierPackageTile) {
            CourierPackageTile packageTile = (CourierPackageTile)blockentity;
            if (!pLevel.f_46443_ && pPlayer.m_7500_() && !packageTile.m_7983_()) {
                ItemStack itemstack = ((Item)ModItems.COURIER_PACKAGE.get()).m_7968_();
                blockentity.m_187476_(itemstack);
                if (packageTile.m_8077_()) {
                    itemstack.m_41714_(packageTile.m_7770_());
                }
                ItemEntity itementity = new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                pLevel.m_7967_((Entity)itementity);
            } else {
                packageTile.m_59640_(pPlayer);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        return super.m_49635_(pState, pParams);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (!pState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            return this.shape;
        }
        Direction dir = (Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            return this.shape;
        }
        return this.shape_turned;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        State state = State.OPENED;
        ItemStack stack = context.m_43722_();
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag != null && tag.m_128441_("Items") && !tag.m_128437_("Items", 10).isEmpty()) {
            state = tag.m_128441_("Sealed") && tag.m_128471_("Sealed") ? State.SEALED : State.CLOSED;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_))).m_61124_(STATE, (Comparable)((Object)state));
    }

    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return CourierPackage.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, HorizontalDirectionalBlock.f_54117_, STATE});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, world, tooltip, flagIn);
    }

    @Override
    public Class<CourierPackageTile> getTileEntityClass() {
        return CourierPackageTile.class;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CourierPackageTile((BlockEntityType)ModTileEntities.COURIER_PACKAGE_TILE.get(), pPos, pState);
    }

    public static enum State implements StringRepresentable
    {
        OPENED("opened"),
        CLOSED("closed"),
        SEALED("sealed");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

