/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom.ai.owl.quirks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.owl.Quirk;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.owl.QuirkController;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.BrowAnimPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class FavoriteBlockQuirk
implements Quirk {
    private Block favoriteBlock;
    private int ticks;
    private int lastUsed = 0;
    private int offset;

    public FavoriteBlockQuirk(Block favoriteBlock, int ticks) {
        this.favoriteBlock = favoriteBlock;
        this.ticks = ticks;
        this.offset = ticks > 0 ? new Random().nextInt(ticks) : 0;
    }

    public FavoriteBlockQuirk() {
        this(Blocks.f_50016_, 0);
    }

    public Block getFavoriteBlock() {
        return this.favoriteBlock;
    }

    public static List<FavoriteBlockQuirk> fromController(QuirkController quirkController) {
        ArrayList<FavoriteBlockQuirk> quirks = new ArrayList<FavoriteBlockQuirk>();
        quirkController.getActiveQuirks().forEach(quirk -> {
            if (quirk instanceof FavoriteBlockQuirk) {
                FavoriteBlockQuirk favoriteBlockQuirk = (FavoriteBlockQuirk)quirk;
                quirks.add(favoriteBlockQuirk);
            }
        });
        return quirks;
    }

    @Override
    public void clientTick(OwlEntity owl) {
    }

    @Override
    public void serverTick(OwlEntity owl) {
        if (owl.f_19797_ - this.lastUsed > 60 && owl.f_19797_ % Math.max(1, this.ticks) == this.offset) {
            BlockPos pos = owl.m_20099_();
            Block block = owl.m_9236_().m_8055_(pos).m_60734_();
            boolean flag = false;
            if (block == this.favoriteBlock) {
                this.lastUsed = owl.f_19797_;
                owl.emotions.setAnger(owl.emotions.getAnger() - 5);
                owl.emotions.setDistress(owl.emotions.getDistress() - 5);
                owl.emotions.setHappiness(owl.emotions.getHappiness() + 15);
                owl.emotionChanged();
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> owl.m_9236_().m_46745_(owl.m_20183_())), (Object)new BrowAnimPacket((Entity)owl, OwlEntity.BrowAnim.BOTH, 5 + owl.m_217043_().m_188503_(10), true));
                flag = true;
            }
            if (!flag) {
                pos = owl.m_20183_();
                block = owl.m_9236_().m_8055_(pos).m_60734_();
                if (block == this.favoriteBlock) {
                    this.lastUsed = owl.f_19797_;
                    owl.emotions.setAnger(owl.emotions.getAnger() - 5);
                    owl.emotions.setDistress(owl.emotions.getDistress() - 5);
                    owl.emotions.setHappiness(owl.emotions.getHappiness() + 15);
                    owl.emotionChanged();
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> owl.m_9236_().m_46745_(owl.m_20183_())), (Object)new BrowAnimPacket((Entity)owl, OwlEntity.BrowAnim.BOTH, 5 + owl.m_217043_().m_188503_(10), true));
                }
            }
        }
    }

    @Override
    public String getName() {
        return "FavoriteBlockQuirk";
    }

    @Override
    public void write(CompoundTag compound) {
        String blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)this.favoriteBlock).toString();
        compound.m_128359_("favoriteBlock", blockRegistryName);
        compound.m_128405_("ticks", this.ticks);
        compound.m_128405_("offset", this.offset);
    }

    @Override
    public void read(CompoundTag compound) {
        String blockRegistryName = compound.m_128461_("favoriteBlock");
        this.favoriteBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockRegistryName));
        this.ticks = compound.m_128451_("ticks");
        this.offset = compound.m_128451_("offset");
    }
}

