/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Optional;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.books.BookHoverOffset;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;

public class BookEntity {
    public float x;
    public float y;
    public float rot;
    public float scale;
    public String entityType;
    public Entity entity;
    public String entityTags;
    public ArrayList<String> entityTagsList;
    public int entityTagsListOn;
    public int entityTagsLastChange;
    public int entityTagsListOnSet;
    public BookHoverOffset offset;
    public float toRotate;
    public float hoverTick;

    BookEntity(float scale, float x, float y, String entityType, Entity entity, String entityTags, ArrayList<String> entityTagsList, BookHoverOffset offset) {
        this.x = x;
        this.y = y;
        this.rot = 0.0f;
        this.scale = scale;
        this.entityType = entityType;
        this.entityTags = entityTags;
        this.entityTagsList = entityTagsList;
        this.entityTagsListOn = 0;
        this.entityTagsListOnSet = 0;
        this.entityTagsLastChange = 0;
        this.entity = entity;
        this.offset = offset;
        this.toRotate = 0.0f;
        this.hoverTick = 0.0f;
    }

    public static BookEntity deserialize(JsonObject object) throws CommandSyntaxException {
        float x = GsonHelper.m_13820_((JsonObject)object, (String)"x", (float)0.0f);
        float y = GsonHelper.m_13820_((JsonObject)object, (String)"y", (float)0.0f);
        float scale = GsonHelper.m_13820_((JsonObject)object, (String)"scale", (float)1.0f);
        String string = GsonHelper.m_13851_((JsonObject)object, (String)"name", (String)"player");
        JsonObject hover_offset = GsonHelper.m_13841_((JsonObject)object, (String)"hover_offset", (JsonObject)new JsonObject());
        float hover_x = GsonHelper.m_13820_((JsonObject)hover_offset, (String)"x", (float)0.0f);
        float hover_y = GsonHelper.m_13820_((JsonObject)hover_offset, (String)"y", (float)0.0f);
        float hover_scale = GsonHelper.m_13820_((JsonObject)hover_offset, (String)"scale", (float)1.0f);
        BookHoverOffset hoverOffset = new BookHoverOffset(hover_x, hover_y, hover_scale);
        Entity entity = null;
        Optional type = EntityType.m_20632_((String)string);
        if (EntityType.m_20632_((String)string).isPresent() && Hexerei.proxy.getLevel() != null) {
            entity = ((EntityType)EntityType.m_20632_((String)string).get()).m_20615_(Hexerei.proxy.getLevel());
        }
        String tagString = "";
        if (object.has("tag")) {
            tagString = GsonHelper.m_13851_((JsonObject)object, (String)"tag", (String)"");
            CompoundTag tag = TagParser.m_129359_((String)tagString);
            if (entity != null) {
                entity.m_20258_(tag);
            }
            if (entity instanceof TamableAnimal) {
                ((TamableAnimal)entity).m_7105_(true);
            }
        }
        JsonArray tag_array = GsonHelper.m_13832_((JsonObject)object, (String)"tag_array", (JsonArray)new JsonArray());
        ArrayList<String> entityTagsList = new ArrayList<String>();
        for (int i = 0; i < tag_array.size(); ++i) {
            JsonObject obj = tag_array.get(i).getAsJsonObject();
            entityTagsList.add(GsonHelper.m_13851_((JsonObject)obj, (String)"tag", (String)""));
        }
        return new BookEntity(scale, x, y, string, entity, tagString, entityTagsList, hoverOffset);
    }
}

