/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.candle;

import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.data.candle.AbstractCandleEffect;
import net.joefoxe.hexerei.data.candle.CandleEffects;
import net.joefoxe.hexerei.data.candle.CandleLayer;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CandleData {
    public boolean returnToBlock;
    public int returnToBlockLastTick;
    public boolean hasCandle;
    public float x;
    public float y;
    public float z;
    public float xO;
    public float yO;
    public float zO;
    public float xTarget;
    public float yTarget;
    public float zTarget;
    public int height;
    public boolean lit;
    public float meltTimer;
    public static int meltTimerMAX = 100;
    public int dyeColor;
    public int cooldown;
    public CandleLayer base;
    public CandleLayer herb;
    public CandleLayer glow;
    public CandleLayer swirl;
    public AbstractCandleEffect effect;
    public ArrayList<AbstractCandleEffect> effects;
    public Component customName;
    public List<String> effectParticle;
    public int baseHeight = 0;

    public CandleData(int dyeColor, boolean returnToBlock, float x, float y, float z, int height, int meltTimer, AbstractCandleEffect effect) {
        this.dyeColor = dyeColor;
        this.returnToBlock = returnToBlock;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xTarget = x;
        this.yTarget = y;
        this.zTarget = z;
        this.height = height;
        this.meltTimer = meltTimer;
        this.effect = effect;
        this.effects = new ArrayList();
        if (effect != null) {
            this.effects.add(effect);
        }
        this.effectParticle = null;
        this.cooldown = 0;
        this.base = new CandleLayer();
        this.herb = new CandleLayer();
        this.glow = new CandleLayer();
        this.swirl = new CandleLayer();
    }

    public CandleData() {
        this(13419416, false, 0.0f, 0.0f, 0.0f, 7, meltTimerMAX, null);
    }

    public void setNotReturn(int returnToBlockLastTick) {
        this.returnToBlock = false;
        this.returnToBlockLastTick = returnToBlockLastTick;
    }

    public float getMeltingSpeedMultiplier() {
        return this.base.meltingSpeedMultiplier * this.herb.meltingSpeedMultiplier * this.glow.meltingSpeedMultiplier * this.swirl.meltingSpeedMultiplier;
    }

    public float getRadiusMultiplier() {
        return this.base.radiusMultiplier * this.herb.radiusMultiplier * this.glow.radiusMultiplier * this.swirl.radiusMultiplier;
    }

    public float getEffectAmplifierMultiplier() {
        return this.base.effectAmplifierMultiplier * this.herb.effectAmplifierMultiplier * this.glow.effectAmplifierMultiplier * this.swirl.effectAmplifierMultiplier;
    }

    public float getEffectCooldownMultiplier() {
        return this.base.effectCooldownMultiplier * this.herb.effectCooldownMultiplier * this.glow.effectCooldownMultiplier * this.swirl.effectCooldownMultiplier;
    }

    public float getEffectDurationMultiplier() {
        return this.base.effectDurationMultiplier * this.herb.effectDurationMultiplier * this.glow.effectDurationMultiplier * this.swirl.effectDurationMultiplier;
    }

    public boolean hasBase() {
        return this.base.layer != null;
    }

    public boolean hasHerb() {
        return this.herb.layer != null;
    }

    public boolean hasGlow() {
        return this.glow.layer != null;
    }

    public boolean hasSwirl() {
        return this.swirl.layer != null;
    }

    public void setEffect(AbstractCandleEffect effect) {
        this.effect = effect;
    }

    public void setOldPos() {
        this.xO = this.x;
        this.yO = this.y;
        this.zO = this.z;
    }

    public void move() {
        this.x = HexereiUtil.moveTo(this.x, this.xTarget, Mth.m_14154_((float)(this.xTarget - this.x)) * 0.075f + 0.00125f);
        this.y = HexereiUtil.moveTo(this.y, this.yTarget, Mth.m_14154_((float)(this.yTarget - this.y)) * 0.115f + 0.00125f);
        this.z = HexereiUtil.moveTo(this.z, this.zTarget, Mth.m_14154_((float)(this.zTarget - this.z)) * 0.075f + 0.00125f);
    }

    public void moveInstantlyToTarget() {
        this.x = this.xTarget;
        this.y = this.yTarget;
        this.z = this.zTarget;
        this.setOldPos();
    }

    public AbstractCandleEffect getEffect() {
        return this.effect;
    }

    public ArrayList<AbstractCandleEffect> getEffects() {
        return this.effects;
    }

    public CompoundTag save() {
        return this.save(new CompoundTag(), false);
    }

    public CompoundTag save(CompoundTag tag, boolean asItem) {
        if (this.dyeColor != 13419416) {
            tag.m_128405_("dyeColor", this.dyeColor);
        }
        if (this.height < 7) {
            tag.m_128405_("height", this.height);
        }
        if (!asItem) {
            tag.m_128350_("meltTimer", this.meltTimer);
            tag.m_128379_("hasCandle", this.hasCandle);
            tag.m_128379_("lit", this.lit);
            tag.m_128379_("returnToBlock", this.returnToBlock);
            tag.m_128405_("cooldown", this.cooldown);
        }
        if (this.effect != null && !this.effect.isEmpty()) {
            tag.m_128359_("effect", this.effect.getLocationName());
        }
        if (this.effectParticle != null && this.effectParticle.size() > 0) {
            CompoundTag compoundTag = new CompoundTag();
            for (int i = 0; i < this.effectParticle.size(); ++i) {
                compoundTag.m_128359_("particle" + i, this.effectParticle.get(i));
                tag.m_128365_("effectParticle", (Tag)compoundTag);
            }
        }
        if (this.base.layer != null) {
            tag.m_128365_("base", (Tag)this.base.save());
        }
        if (this.herb.layer != null) {
            tag.m_128365_("herb", (Tag)this.herb.save());
        }
        if (this.glow.layer != null) {
            tag.m_128365_("glow", (Tag)this.glow.save());
        }
        if (this.swirl.layer != null) {
            tag.m_128365_("swirl", (Tag)this.swirl.save());
        }
        if (this.customName != null) {
            tag.m_128359_("customName", Component.Serializer.m_130703_((Component)this.customName));
        }
        return tag;
    }

    public void load(CompoundTag tag, boolean fromItem) {
        CompoundTag ct;
        this.dyeColor = tag.m_128441_("dyeColor") ? tag.m_128451_("dyeColor") : 13419416;
        this.height = tag.m_128441_("height") ? tag.m_128451_("height") : 7;
        this.meltTimer = tag.m_128441_("meltTimer") ? tag.m_128457_("meltTimer") : (float)meltTimerMAX;
        this.hasCandle = tag.m_128441_("hasCandle") ? tag.m_128471_("hasCandle") : fromItem;
        this.lit = tag.m_128441_("lit") ? tag.m_128471_("lit") : false;
        this.returnToBlock = tag.m_128441_("returnToBlock") ? tag.m_128471_("returnToBlock") : true;
        if (tag.m_128441_("effect")) {
            this.setEffect(CandleEffects.getEffect(tag.m_128461_("effect")));
            this.cooldown = tag.m_128451_("cooldown");
        } else {
            this.effect = null;
            this.cooldown = 0;
        }
        if (tag.m_128441_("effectParticle")) {
            this.effectParticle = new ArrayList<String>();
            CompoundTag compoundTag = tag.m_128469_("effectParticle");
            for (int i = 0; i < compoundTag.m_128440_(); ++i) {
                this.effectParticle.add(compoundTag.m_128461_("particle" + i));
            }
        } else {
            this.effectParticle = new ArrayList<String>();
        }
        if (tag.m_128441_("base")) {
            ct = tag.m_128469_("base");
            this.base = new CandleLayer(ct.m_128457_("meltingSpeedMultiplier"), ct.m_128457_("radiusMultiplier"), ct.m_128457_("effectAmplifierMultiplier"), ct.m_128457_("effectCooldownMultiplier"), ct.m_128457_("effectDurationMultiplier"), new ResourceLocation(ct.m_128461_("layer")), ct.m_128471_("layerFromBlockLocation"));
        } else {
            this.base = new CandleLayer();
        }
        if (tag.m_128441_("herb")) {
            ct = tag.m_128469_("herb");
            this.herb = new CandleLayer(ct.m_128457_("meltingSpeedMultiplier"), ct.m_128457_("radiusMultiplier"), ct.m_128457_("effectAmplifierMultiplier"), ct.m_128457_("effectCooldownMultiplier"), ct.m_128457_("effectDurationMultiplier"), new ResourceLocation(ct.m_128461_("layer")), ct.m_128471_("layerFromBlockLocation"));
        } else {
            this.herb = new CandleLayer();
        }
        if (tag.m_128441_("glow")) {
            ct = tag.m_128469_("glow");
            this.glow = new CandleLayer(ct.m_128457_("meltingSpeedMultiplier"), ct.m_128457_("radiusMultiplier"), ct.m_128457_("effectAmplifierMultiplier"), ct.m_128457_("effectCooldownMultiplier"), ct.m_128457_("effectDurationMultiplier"), new ResourceLocation(ct.m_128461_("layer")), ct.m_128471_("layerFromBlockLocation"));
        } else {
            this.glow = new CandleLayer();
        }
        if (tag.m_128441_("swirl")) {
            ct = tag.m_128469_("swirl");
            this.swirl = new CandleLayer(ct.m_128457_("meltingSpeedMultiplier"), ct.m_128457_("radiusMultiplier"), ct.m_128457_("effectAmplifierMultiplier"), ct.m_128457_("effectCooldownMultiplier"), ct.m_128457_("effectDurationMultiplier"), new ResourceLocation(ct.m_128461_("layer")), ct.m_128471_("layerFromBlockLocation"));
        } else {
            this.swirl = new CandleLayer();
        }
        this.customName = tag.m_128441_("customName") ? Component.Serializer.m_130701_((String)tag.m_128461_("customName")) : null;
    }

    public void load(CompoundTag tag) {
        this.load(tag, false);
    }
}

