/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.AddToCandleRecipe;
import net.joefoxe.hexerei.data.recipes.BookOfShadowsRecipe;
import net.joefoxe.hexerei.data.recipes.CauldronEmptyingRecipe;
import net.joefoxe.hexerei.data.recipes.CrowFluteRecipe;
import net.joefoxe.hexerei.data.recipes.DipperRecipe;
import net.joefoxe.hexerei.data.recipes.DryingRackRecipe;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.data.recipes.KeychainRecipe;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.joefoxe.hexerei.data.recipes.PestleAndMortarRecipe;
import net.joefoxe.hexerei.data.recipes.WoodcutterRecipe;
import net.joefoxe.hexerei.fluid.ModFluids;
import net.joefoxe.hexerei.fluid.PotionFluid;
import net.joefoxe.hexerei.fluid.PotionFluidHandler;
import net.joefoxe.hexerei.fluid.PotionMixingRecipes;
import net.joefoxe.hexerei.integration.jei.AddToCandleRecipeCategory;
import net.joefoxe.hexerei.integration.jei.BloodSigilRecipeCategory;
import net.joefoxe.hexerei.integration.jei.BloodSigilRecipeJEI;
import net.joefoxe.hexerei.integration.jei.BookOfShadowsRecipeCategory;
import net.joefoxe.hexerei.integration.jei.BottlingRecipeCategory;
import net.joefoxe.hexerei.integration.jei.BottlingRecipeJEI;
import net.joefoxe.hexerei.integration.jei.DipperRecipeCategory;
import net.joefoxe.hexerei.integration.jei.DryingRackRecipeCategory;
import net.joefoxe.hexerei.integration.jei.FluidMixingRecipeCategory;
import net.joefoxe.hexerei.integration.jei.FluteRecipeCategory;
import net.joefoxe.hexerei.integration.jei.KeychainApplyRecipeCategory;
import net.joefoxe.hexerei.integration.jei.MixingCauldronRecipeCategory;
import net.joefoxe.hexerei.integration.jei.MixingCauldronTransferInfo;
import net.joefoxe.hexerei.integration.jei.PestleAndMortarRecipeCategory;
import net.joefoxe.hexerei.integration.jei.PlantPickingRecipeCategory;
import net.joefoxe.hexerei.integration.jei.PlantPickingRecipeJEI;
import net.joefoxe.hexerei.integration.jei.PotionFluidSubtypeInterpreter;
import net.joefoxe.hexerei.integration.jei.WoodcutterRecipeCategory;
import net.joefoxe.hexerei.screen.BroomScreen;
import net.joefoxe.hexerei.screen.CofferScreen;
import net.joefoxe.hexerei.screen.CrowScreen;
import net.joefoxe.hexerei.screen.MixingCauldronScreen;
import net.joefoxe.hexerei.screen.OwlScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class HexereiJei
implements IModPlugin {
    public static IRecipesGui runtime;
    public static RecipeManager recipeManager;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("hexerei", "jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime.getRecipesGui();
        super.onRuntimeAvailable(jeiRuntime);
    }

    public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        PotionFluidSubtypeInterpreter interpreter = new PotionFluidSubtypeInterpreter();
        PotionFluid potionFluid = (PotionFluid)((Object)ModFluids.POTION.get());
        registration.registerSubtypeInterpreter(ForgeTypes.FLUID_STACK, (Object)potionFluid.m_5613_(), (IIngredientSubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter(ForgeTypes.FLUID_STACK, (Object)potionFluid.m_5615_(), (IIngredientSubtypeInterpreter)interpreter);
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip() {
        return HexereiJei.addFluidTooltip(-1);
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip(int mbAmount) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            FluidStack fluidStack = (FluidStack)displayed.get();
            if (fluidStack.getFluid().m_6212_((Fluid)ModFluids.POTION.get())) {
                Component name = fluidStack.getDisplayName();
                if (tooltip.isEmpty()) {
                    tooltip.add(0, name);
                } else {
                    tooltip.set(0, name);
                }
                ArrayList<Component> potionTooltip = new ArrayList<Component>();
                PotionFluidHandler.addPotionTooltip(fluidStack, potionTooltip, 1.0f);
                tooltip.addAll(1, potionTooltip.stream().toList());
            }
            int amount = mbAmount == -1 ? fluidStack.getAmount() : mbAmount;
            MutableComponent text = Component.m_237113_((String)String.valueOf(amount)).m_7220_((Component)Component.m_237115_((String)"hexerei.generic.unit.millibuckets")).m_130940_(ChatFormatting.GOLD);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                List siblings = ((Component)tooltip.get(0)).m_7360_();
                siblings.add(Component.m_237113_((String)" "));
                siblings.add(text);
            }
        };
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip(int mbAmount, Component component) {
        return HexereiJei.addFluidTooltip(mbAmount, List.of(component));
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip(int mbAmount, List<Component> list) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            tooltip.addAll(list);
            FluidStack fluidStack = (FluidStack)displayed.get();
            if (fluidStack.getFluid().m_6212_((Fluid)ModFluids.POTION.get())) {
                Component name = fluidStack.getDisplayName();
                if (tooltip.isEmpty()) {
                    tooltip.add(0, name);
                } else {
                    tooltip.set(0, name);
                }
                ArrayList<Component> potionTooltip = new ArrayList<Component>();
                PotionFluidHandler.addPotionTooltip(fluidStack, potionTooltip, 1.0f);
                tooltip.addAll(1, potionTooltip.stream().toList());
            }
            int amount = mbAmount == -1 ? fluidStack.getAmount() : mbAmount;
            MutableComponent text = Component.m_237113_((String)String.valueOf(amount)).m_7220_((Component)Component.m_237115_((String)"hexerei.generic.unit.millibuckets")).m_130940_(ChatFormatting.GOLD);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                List siblings = ((Component)tooltip.get(0)).m_7360_();
                siblings.add(Component.m_237113_((String)" "));
                siblings.add(text);
            }
        };
    }

    public static IRecipeSlotTooltipCallback addFluidTooltipDipper(int mbAmount) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
            if (displayed.isEmpty()) {
                return;
            }
            List list = ((Component)tooltip.get(tooltip.size() - 2)).m_7360_();
            list.add(Component.m_237115_((String)" - per dip action").m_130948_(Style.f_131099_.m_178520_(0xAAAAAA)));
            FluidStack fluidStack = (FluidStack)displayed.get();
            if (fluidStack.getFluid().m_6212_((Fluid)ModFluids.POTION.get())) {
                Component name = fluidStack.getDisplayName();
                if (tooltip.isEmpty()) {
                    tooltip.add(0, name);
                } else {
                    tooltip.set(0, name);
                }
                ArrayList<Component> potionTooltip = new ArrayList<Component>();
                PotionFluidHandler.addPotionTooltip(fluidStack, potionTooltip, 1.0f);
                tooltip.addAll(1, potionTooltip.stream().toList());
            }
            int amount = mbAmount == -1 ? fluidStack.getAmount() : mbAmount;
            MutableComponent text = Component.m_237113_((String)String.valueOf(amount)).m_7220_((Component)Component.m_237115_((String)"hexerei.generic.unit.millibuckets")).m_130940_(ChatFormatting.GOLD);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                List siblings = ((Component)tooltip.get(0)).m_7360_();
                siblings.add(Component.m_237113_((String)" "));
                siblings.add(text);
            }
        };
    }

    public static IRecipeSlotTooltipCallback addExtraTooltips(List<Component> list) {
        return (view, tooltip) -> {
            if (list.isEmpty()) {
                return;
            }
            tooltip.addAll(list);
        };
    }

    public static List<FluidStack> withImprovedVisibility(List<FluidStack> stacks) {
        return stacks.stream().map(HexereiJei::withImprovedVisibility).collect(Collectors.toList());
    }

    public static FluidStack withImprovedVisibility(FluidStack stack) {
        FluidStack display = stack.copy();
        int displayedAmount = (int)((float)stack.getAmount() * 0.75f) + 250;
        display.setAmount(displayedAmount);
        return display;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (PotionMixingRecipes.ALL == null || PotionMixingRecipes.ALL.isEmpty()) {
            PotionMixingRecipes.ALL = PotionMixingRecipes.createRecipes();
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new MixingCauldronRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new AddToCandleRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new FluteRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new BookOfShadowsRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new KeychainApplyRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new FluidMixingRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new FluidMixingRecipeCategory(registration.getJeiHelpers().getGuiHelper(), "Potion"), new DipperRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new PestleAndMortarRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new WoodcutterRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new BottlingRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new BloodSigilRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new PlantPickingRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new DryingRackRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get()), new RecipeType[]{new RecipeType(MixingCauldronRecipeCategory.UID, MixingCauldronRecipe.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get()), new RecipeType[]{new RecipeType(FluidMixingRecipeCategory.UID, FluidMixingRecipe.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get()), new RecipeType[]{new RecipeType(FluidMixingRecipeCategory.POTION_UID, FluidMixingRecipe.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get()), new RecipeType[]{new RecipeType(BottlingRecipeCategory.UID, CauldronEmptyingRecipe.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get()), new RecipeType[]{new RecipeType(BloodSigilRecipeCategory.UID, BloodSigilRecipeJEI.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get()), new RecipeType[]{new RecipeType(DipperRecipeCategory.UID, DipperRecipe.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CANDLE_DIPPER.get()), new RecipeType[]{new RecipeType(DipperRecipeCategory.UID, DipperRecipe.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.HERB_DRYING_RACK.get()), new RecipeType[]{new RecipeType(DryingRackRecipeCategory.UID, DryingRackRecipe.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WILLOW_WOODCUTTER.get()), new RecipeType[]{new RecipeType(WoodcutterRecipeCategory.UID, WoodcutterRecipe.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MAHOGANY_WOODCUTTER.get()), new RecipeType[]{new RecipeType(WoodcutterRecipeCategory.UID, WoodcutterRecipe.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WITCH_HAZEL_WOODCUTTER.get()), new RecipeType[]{new RecipeType(WoodcutterRecipeCategory.UID, WoodcutterRecipe.class)});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PESTLE_AND_MORTAR.get()), new RecipeType[]{new RecipeType(PestleAndMortarRecipeCategory.UID, PestleAndMortarRecipe.class)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MixingCauldronScreen.class, 101, 41, 24, 24, new RecipeType[]{new RecipeType(MixingCauldronRecipeCategory.UID, MixingCauldronRecipe.class), new RecipeType(FluidMixingRecipeCategory.UID, FluidMixingRecipe.class), new RecipeType(BottlingRecipeCategory.UID, CauldronEmptyingRecipe.class), new RecipeType(BloodSigilRecipeCategory.UID, BloodSigilRecipeJEI.class), new RecipeType(FluidMixingRecipeCategory.POTION_UID, FluidMixingRecipe.class)});
        registration.addGuiContainerHandler(MixingCauldronScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<MixingCauldronScreen>(){

            public List<Rect2i> getGuiExtraAreas(MixingCauldronScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                Rect2i rect2i = new Rect2i(gui.getGuiLeft() + 23, gui.getGuiTop(), 142, 97);
                ret.add(rect2i);
                rect2i = new Rect2i(gui.getGuiLeft() + 160, gui.getGuiTop() + 32, 49, 48);
                ret.add(rect2i);
                rect2i = new Rect2i(gui.getGuiLeft(), gui.getGuiTop() + 97, 188, 30);
                ret.add(rect2i);
                return ret;
            }
        });
        registration.addGuiContainerHandler(CrowScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<CrowScreen>(){

            public List<Rect2i> getGuiExtraAreas(CrowScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                Rect2i rect2i = new Rect2i(gui.getGuiLeft(), gui.getGuiTop() - 28, 188, 153);
                ret.add(rect2i);
                rect2i = new Rect2i(gui.getGuiLeft() + 184 - 28 + (int)gui.whitelistOffset, gui.getGuiTop() + 17 - 28 + 3, 39, 101);
                ret.add(rect2i);
                rect2i = new Rect2i(gui.getGuiLeft() - 5 - (int)gui.leftPanelOffset, gui.getGuiTop() + 17 - 28 + 3, 39, 101);
                ret.add(rect2i);
                return ret;
            }
        });
        registration.addGuiContainerHandler(OwlScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<OwlScreen>(){

            public List<Rect2i> getGuiExtraAreas(OwlScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                if (!gui.quirkSideBarHidden) {
                    Rect2i rect2i = new Rect2i(gui.getGuiLeft() + 174, gui.getGuiTop() + 37, 26, 26);
                    ret.add(rect2i);
                }
                return ret;
            }
        });
        registration.addGuiContainerHandler(CofferScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<CofferScreen>(){

            public List<Rect2i> getGuiExtraAreas(CofferScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                Rect2i rect2i = new Rect2i(gui.getGuiLeft(), gui.getGuiTop() - 28, 214, 157);
                ret.add(rect2i);
                return ret;
            }
        });
        registration.addGuiContainerHandler(BroomScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BroomScreen>(){

            public List<Rect2i> getGuiExtraAreas(BroomScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                Rect2i rect2i = new Rect2i(gui.getGuiLeft(), gui.getGuiTop() - 34, 214, 82 + gui.offset);
                ret.add(rect2i);
                rect2i = new Rect2i(gui.getGuiLeft(), gui.getGuiTop() + 79 + gui.offset - 34, 214, 34);
                ret.add(rect2i);
                rect2i = new Rect2i(gui.getGuiLeft() + 184, gui.getGuiTop() + 55 + gui.offset + (int)gui.dropdownOffset - 34, 26, 58);
                ret.add(rect2i);
                return ret;
            }
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm;
        recipeManager = rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List mixing_recipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)MixingCauldronRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(MixingCauldronRecipeCategory.UID, MixingCauldronRecipe.class), mixing_recipes);
        if (Minecraft.m_91087_().f_91073_ != null) {
            List<CraftingRecipe> add_to_candle_recipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44107_);
            List<Object> flute_dye_recipes = new ArrayList(add_to_candle_recipes);
            List<Object> book_recipe = new ArrayList(add_to_candle_recipes);
            List<Object> keychainRecipe = new ArrayList(add_to_candle_recipes);
            add_to_candle_recipes = add_to_candle_recipes.stream().filter(craftingRecipe -> craftingRecipe instanceof AddToCandleRecipe).toList();
            registration.addRecipes(new RecipeType(AddToCandleRecipeCategory.UID, AddToCandleRecipe.class), add_to_candle_recipes);
            flute_dye_recipes = flute_dye_recipes.stream().filter(craftingRecipe -> craftingRecipe instanceof CrowFluteRecipe).toList();
            registration.addRecipes(new RecipeType(FluteRecipeCategory.UID, CrowFluteRecipe.class), flute_dye_recipes);
            book_recipe = book_recipe.stream().filter(craftingRecipe -> craftingRecipe instanceof BookOfShadowsRecipe).toList();
            registration.addRecipes(RecipeTypes.CRAFTING, book_recipe);
            keychainRecipe = keychainRecipe.stream().filter(craftingRecipe -> craftingRecipe instanceof KeychainRecipe).toList();
            registration.addRecipes(new RecipeType(KeychainApplyRecipeCategory.UID, KeychainRecipe.class), keychainRecipe);
        }
        List fluid_mixing_recipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)FluidMixingRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(FluidMixingRecipeCategory.UID, FluidMixingRecipe.class), fluid_mixing_recipes);
        if (PotionMixingRecipes.ALL == null || PotionMixingRecipes.ALL.isEmpty()) {
            PotionMixingRecipes.ALL = PotionMixingRecipes.createRecipes();
        }
        if (PotionMixingRecipes.ALL != null) {
            registration.addRecipes(new RecipeType(FluidMixingRecipeCategory.POTION_UID, FluidMixingRecipe.class), PotionMixingRecipes.ALL);
        }
        List pestle_and_mortar_recipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)PestleAndMortarRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(PestleAndMortarRecipeCategory.UID, PestleAndMortarRecipe.class), pestle_and_mortar_recipes);
        List dipper_recipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)DipperRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(DipperRecipeCategory.UID, DipperRecipe.class), dipper_recipes);
        List drying_rack_recipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)DryingRackRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(DryingRackRecipeCategory.UID, DryingRackRecipe.class), drying_rack_recipes);
        List woodcutter_recipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)WoodcutterRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(WoodcutterRecipeCategory.UID, WoodcutterRecipe.class), woodcutter_recipes);
        List<CauldronEmptyingRecipe> bottling_recipes = BottlingRecipeJEI.getRecipeList(rm);
        registration.addRecipes(new RecipeType(BottlingRecipeCategory.UID, CauldronEmptyingRecipe.class), bottling_recipes);
        List<BloodSigilRecipeJEI> blood_sigil_recipes = BloodSigilRecipeJEI.getRecipeList();
        registration.addRecipes(new RecipeType(BloodSigilRecipeCategory.UID, BloodSigilRecipeJEI.class), blood_sigil_recipes);
        List<PlantPickingRecipeJEI> plant_picking_recipes = PlantPickingRecipeJEI.getRecipeList();
        registration.addRecipes(new RecipeType(PlantPickingRecipeCategory.UID, PlantPickingRecipeJEI.class), plant_picking_recipes);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new MixingCauldronTransferInfo(registration.getTransferHelper()), new RecipeType(MixingCauldronRecipeCategory.UID, MixingCauldronRecipe.class));
    }

    public static void showUses(final FluidStack fluid) {
        if (runtime == null) {
            return;
        }
        runtime.show((IFocus)new IFocus<FluidStack>(){

            public ITypedIngredient<FluidStack> getTypedValue() {
                return new ITypedIngredient<FluidStack>(){

                    public IIngredientTypeWithSubtypes<Fluid, FluidStack> getType() {
                        return ForgeTypes.FLUID_STACK;
                    }

                    public FluidStack getIngredient() {
                        return fluid;
                    }

                    public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                        if (ingredientType == ForgeTypes.FLUID_STACK) {
                            return Optional.of(fluid);
                        }
                        return Optional.empty();
                    }
                };
            }

            public RecipeIngredientRole getRole() {
                return RecipeIngredientRole.CATALYST;
            }

            public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                return Optional.empty();
            }
        });
        if (!(Minecraft.m_91087_().f_91080_ instanceof IRecipesGui)) {
            if (runtime == null) {
                return;
            }
            runtime.show((IFocus)new IFocus<FluidStack>(){

                public ITypedIngredient<FluidStack> getTypedValue() {
                    return new ITypedIngredient<FluidStack>(){

                        public IIngredientTypeWithSubtypes<Fluid, FluidStack> getType() {
                            return ForgeTypes.FLUID_STACK;
                        }

                        public FluidStack getIngredient() {
                            return fluid;
                        }

                        public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                            if (ingredientType == ForgeTypes.FLUID_STACK) {
                                return Optional.of(fluid);
                            }
                            return Optional.empty();
                        }
                    };
                }

                public RecipeIngredientRole getRole() {
                    return RecipeIngredientRole.INPUT;
                }

                public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                    return Optional.empty();
                }
            });
        }
    }

    public static void showUses(final ItemStack item) {
        if (runtime == null) {
            return;
        }
        runtime.show((IFocus)new IFocus<ItemStack>(){

            public ITypedIngredient<ItemStack> getTypedValue() {
                return new ITypedIngredient<ItemStack>(){

                    public IIngredientType<ItemStack> getType() {
                        return VanillaTypes.ITEM_STACK;
                    }

                    public ItemStack getIngredient() {
                        return item;
                    }

                    public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                        if (ingredientType == VanillaTypes.ITEM_STACK) {
                            return Optional.of(item);
                        }
                        return Optional.empty();
                    }
                };
            }

            public RecipeIngredientRole getRole() {
                return RecipeIngredientRole.CATALYST;
            }

            public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                return Optional.empty();
            }
        });
        if (!(Minecraft.m_91087_().f_91080_ instanceof IRecipesGui)) {
            if (runtime == null) {
                return;
            }
            runtime.show((IFocus)new IFocus<ItemStack>(){

                public ITypedIngredient<ItemStack> getTypedValue() {
                    return new ITypedIngredient<ItemStack>(){

                        public IIngredientType<ItemStack> getType() {
                            return VanillaTypes.ITEM_STACK;
                        }

                        public ItemStack getIngredient() {
                            return item;
                        }

                        public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                            if (ingredientType == VanillaTypes.ITEM_STACK) {
                                return Optional.of(item);
                            }
                            return Optional.empty();
                        }
                    };
                }

                public RecipeIngredientRole getRole() {
                    return RecipeIngredientRole.INPUT;
                }

                public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                    return Optional.empty();
                }
            });
        }
    }

    public static void showRecipe(final ItemStack item) {
        if (runtime == null) {
            return;
        }
        runtime.show((IFocus)new IFocus<ItemStack>(){

            public ITypedIngredient<ItemStack> getTypedValue() {
                return new ITypedIngredient<ItemStack>(){

                    public IIngredientType<ItemStack> getType() {
                        return VanillaTypes.ITEM_STACK;
                    }

                    public ItemStack getIngredient() {
                        return item;
                    }

                    public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                        if (ingredientType == VanillaTypes.ITEM_STACK) {
                            return Optional.of(item);
                        }
                        return Optional.empty();
                    }
                };
            }

            public RecipeIngredientRole getRole() {
                return RecipeIngredientRole.OUTPUT;
            }

            public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                return Optional.empty();
            }
        });
    }

    public static void showRecipe(final FluidStack fluid) {
        if (runtime == null) {
            return;
        }
        runtime.show((IFocus)new IFocus<FluidStack>(){

            public ITypedIngredient<FluidStack> getTypedValue() {
                return new ITypedIngredient<FluidStack>(){

                    public IIngredientType<FluidStack> getType() {
                        return ForgeTypes.FLUID_STACK;
                    }

                    public FluidStack getIngredient() {
                        return fluid;
                    }

                    public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                        if (ingredientType == ForgeTypes.FLUID_STACK) {
                            return Optional.of(fluid);
                        }
                        return Optional.empty();
                    }
                };
            }

            public RecipeIngredientRole getRole() {
                return RecipeIngredientRole.OUTPUT;
            }

            public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                return Optional.empty();
            }
        });
    }
}

