/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.recipes.KeychainRecipe;
import net.joefoxe.hexerei.integration.jei.ExtraKeychainIcon;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.KeychainItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class KeychainApplyRecipeCategory
implements IRecipeCategory<KeychainRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("hexerei", "keychain_apply");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/gui/add_to_candle_gui_jei.png");
    private IDrawable background;
    private final IDrawable icon;
    public ItemStack itemShown;
    private boolean findNewItem;

    public List<Component> getTooltipStrings(KeychainRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.isHovering(mouseX, mouseY, 33.0, 19.0, 16.0, 16.0)) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)Component.m_237115_((String)"Any Item"));
            tooltip.add((Component)Component.m_237110_((String)"item shown: - %s", (Object[])new Object[]{Component.m_237115_((String)this.itemShown.m_41786_().getString()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xCC5522)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            return tooltip;
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public KeychainApplyRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 144, 86);
        this.icon = new ExtraKeychainIcon(() -> new ItemStack((ItemLike)ModItems.CANDLE.get()));
        Collection col = ForgeRegistries.ITEMS.getValues();
        Random rand = new Random();
        Object object = col.toArray()[(int)((float)col.size() * rand.nextFloat())];
        if (object instanceof Item) {
            Item item = (Item)object;
            this.itemShown = new ItemStack((ItemLike)item);
        }
    }

    public RecipeType<KeychainRecipe> getRecipeType() {
        return new RecipeType(new ResourceLocation("hexerei", "keychain_apply"), KeychainRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"Keychain Attach");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, KeychainRecipe recipe, IFocusGroup focuses) {
        builder.moveRecipeTransferButton(160, 90);
        builder.setShapeless();
        builder.addSlot(RecipeIngredientRole.INPUT, 15, 19).addItemStack(new ItemStack((ItemLike)ModItems.BROOM_KEYCHAIN.get()));
    }

    public void draw(KeychainRecipe recipe, IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        float newItem = Hexerei.getClientTicks() % 200.0f / 200.0f;
        if (newItem <= 0.05f && this.findNewItem || this.itemShown == null) {
            this.findNewItem = false;
            if (Minecraft.m_91087_().f_91073_ != null) {
                Collection col = ForgeRegistries.ITEMS.getValues();
                Random rand = new Random();
                Object object = col.toArray()[(int)((float)col.size() * rand.nextFloat())];
                if (object instanceof Item) {
                    Item item = (Item)object;
                    this.itemShown = new ItemStack((ItemLike)item);
                }
            }
        }
        if (newItem > 0.05f) {
            this.findNewItem = true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer renderer = minecraft.m_91291_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Component outputName = this.getTitle();
        RenderSystem.enableDepthTest();
        if (this.isHovering(mouseX, mouseY, 33.0, 19.0, 16.0, 16.0)) {
            guiGraphics.m_280509_(33, 19, 49, 35, 0x66FFFFFF);
        }
        if (!renderer.m_174264_(this.itemShown, null, null, 0).m_7547_()) {
            Lighting.m_84930_();
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.BROOM_KEYCHAIN.get());
        ItemStack keychain = new ItemStack((ItemLike)ModItems.BROOM_KEYCHAIN.get());
        ItemStack other = this.itemShown;
        if (keychain.m_41720_() instanceof KeychainItem && !other.m_41619_()) {
            CompoundTag tag = new CompoundTag();
            if (keychain.m_41782_()) {
                tag = keychain.m_41783_();
            }
            ListTag listtag = new ListTag();
            if (!other.m_41619_()) {
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128344_("Slot", (byte)0);
                other.m_41739_(compoundtag);
                listtag.add((Object)compoundtag);
            }
            tag.m_128365_("Items", (Tag)listtag);
            keychain.m_41751_(tag);
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(41.0f, 27.0f, 0.0f);
        guiGraphics.m_280168_().m_252931_(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
        guiGraphics.m_280168_().m_85850_().m_252943_().rotate((Quaternionfc)Axis.f_252436_.m_252977_(-45.0f));
        this.renderItem(this.itemShown, (Level)minecraft.f_91073_, guiGraphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(117.0f, 45.0f, 0.0f);
        guiGraphics.m_280168_().m_252931_(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
        guiGraphics.m_280168_().m_85850_().m_252943_().rotate((Quaternionfc)Axis.f_252436_.m_252977_(-45.0f));
        this.renderItem(keychain, (Level)minecraft.f_91073_, guiGraphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0);
        guiGraphics.m_280168_().m_85849_();
        buffer.m_109911_();
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
        int width = minecraft.f_91062_.m_92852_((FormattedText)outputName);
        Objects.requireNonNull(minecraft.f_91062_);
        float lineHeight = 9.0f / 2.0f;
        if (width > 131) {
            float percent = (float)width / 131.0f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(1.0f / percent, 1.0f / percent, 1.0f / percent);
            minecraft.f_91062_.m_272077_(outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            guiGraphics.m_280168_().m_85849_();
        } else {
            minecraft.f_91062_.m_272077_(outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.GUI, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, level, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.m_110937_().renderModel(poseStack.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    poseStack.m_85837_(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

