/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CrystalBallTile
extends BlockEntity {
    public float degreesSpun = 0.0f;
    public float degreesSpunOld = 0.0f;
    public float orbOffset = 0.0f;
    public float moonAlpha = 0.0f;
    public float centerYaw = 0.0f;
    public float centerYawO = 0.0f;
    public float centerYawIncrement = 0.0f;
    public float centerPitch = 0.0f;
    public float centerPitchO = 0.0f;
    public float centerPitchIncrement = 0.0f;
    public long lastInteractedWith = 0L;
    public Player nearestPlayer = null;
    public long lastLocatedNearestPlayer;

    public CrystalBallTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public CrystalBallTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.CRYSTAL_BALL_TILE.get(), blockPos, blockState);
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20182_().f_82479_ - (double)pos.m_123341_();
        double deltaY = entity.m_20182_().f_82480_ - (double)pos.m_123342_();
        double deltaZ = entity.m_20182_().f_82481_ - (double)pos.m_123343_();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
    }

    public float updateIncrement(float currentAngle, float targetAngle, float lastIncrement) {
        float angleDifference = (targetAngle = this.normalizeAngle(targetAngle)) - (currentAngle = this.normalizeAngle(currentAngle));
        if (angleDifference > 180.0f) {
            angleDifference -= 360.0f;
        } else if (angleDifference < -180.0f) {
            angleDifference += 360.0f;
        }
        float distance = Math.abs(angleDifference);
        if (Mth.m_14154_((float)lastIncrement) < 0.3f && distance < 1.0f) {
            return 0.0f;
        }
        return (lastIncrement + (distance / 180.0f * (distance / 180.0f) + 0.125f) * (float)(angleDifference > 0.0f ? 1 : -1)) * 0.96f;
    }

    public float updateAngle(float currentAngle, float maxIncrement) {
        currentAngle = this.normalizeAngle(currentAngle);
        return this.normalizeAngle(currentAngle += maxIncrement);
    }

    private float normalizeAngle(float angle) {
        while (angle > 90.0f) {
            angle -= 360.0f;
        }
        while (angle < -270.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private float normalize(float angle) {
        while (angle > 360.0f) {
            angle -= 360.0f;
        }
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public void tick() {
        this.degreesSpunOld = this.degreesSpun;
        this.centerPitchO = this.centerPitch;
        this.centerYawO = this.centerYaw;
        float currentTime = this.f_58857_.m_46467_();
        if (this.f_58857_.m_46467_() - this.lastLocatedNearestPlayer > 20L) {
            this.lastLocatedNearestPlayer = this.f_58857_.m_46467_();
            this.nearestPlayer = this.f_58857_.m_45924_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 4.0, false);
        }
        if (this.nearestPlayer != null && CrystalBallTile.getDistanceToEntity((Entity)this.nearestPlayer, this.f_58858_) < 4.0) {
            this.degreesSpun = this.normalize(this.degreesSpun + 0.5f);
            this.orbOffset = HexereiUtil.moveTo(this.orbOffset, (float)Math.sin(Math.PI * (double)currentTime / 30.0) / 4.0f, 0.25f);
            this.moonAlpha = HexereiUtil.moveTo(this.moonAlpha, 1.0f, 0.05f);
            Vec3 playerPos = this.nearestPlayer.m_20182_();
            double dx = playerPos.f_82479_ - (double)this.m_58899_().m_123341_() - 0.5;
            double dy = playerPos.f_82480_ + (double)this.nearestPlayer.m_20192_() - (double)this.m_58899_().m_123342_() - 0.5;
            double dz = playerPos.f_82481_ - (double)this.m_58899_().m_123343_() - 0.5;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            float yaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, distance) * 57.29577951308232));
            if (this.f_58857_.m_46467_() - this.lastInteractedWith > 20L) {
                this.centerYawIncrement = this.updateIncrement(this.centerYaw, yaw, this.centerYawIncrement);
                this.centerPitchIncrement = this.updateIncrement(this.centerPitch, pitch, this.centerPitchIncrement);
            }
            this.centerYaw = this.updateAngle(this.centerYaw, this.centerYawIncrement);
            this.centerPitch = this.updateAngle(this.centerPitch, this.centerPitchIncrement);
            this.centerPitch = HexereiUtil.moveTo(this.centerPitch, 0.0f, Math.abs(this.centerYawIncrement / 10.0f));
        } else {
            this.orbOffset = HexereiUtil.moveTo(this.orbOffset, -1.0f, 0.1f);
            this.moonAlpha = HexereiUtil.moveTo(this.moonAlpha, 0.0f, 0.05f);
        }
    }

    public boolean m_7531_(int pId, int pType) {
        if (pId == 1) {
            this.centerYawIncrement = Mth.m_14036_((float)(this.centerYawIncrement + (float)(this.centerYawIncrement > 0.0f ? 1 : -1) + this.centerYawIncrement / 10.0f), (float)-100.0f, (float)100.0f);
            this.lastInteractedWith = this.f_58857_.m_46467_();
            return true;
        }
        return super.m_7531_(pId, pType);
    }
}

