/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.CourierLetter;
import net.joefoxe.hexerei.block.custom.CourierPackage;
import net.joefoxe.hexerei.block.custom.OwlCourierDepotWall;
import net.joefoxe.hexerei.data.owl.ClientOwlCourierDepotData;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.OwlCourierDepotTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;

public class OwlCourierDepotRenderer
implements BlockEntityRenderer<OwlCourierDepotTile> {
    private final Font font;
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer = this.minecraft.m_91291_();
    private final ItemModelShaper shaper = this.itemRenderer.m_115103_();

    public OwlCourierDepotRenderer() {
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public void render(OwlCourierDepotTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        List list;
        BlockEntity blockEntity;
        BlockState state = tileEntityIn.m_58904_().m_8055_(tileEntityIn.m_58899_());
        if (!state.m_155947_() || !((blockEntity = tileEntityIn.m_58904_().m_7702_(tileEntityIn.m_58899_())) instanceof OwlCourierDepotTile)) {
            return;
        }
        OwlCourierDepotTile owlCourierDepotTile = (OwlCourierDepotTile)blockEntity;
        int col = 4607830;
        int colr = (int)((double)FastColor.ARGB32.m_13665_((int)col) * 0.4);
        int colg = (int)((double)FastColor.ARGB32.m_13667_((int)col) * 0.4);
        int colb = (int)((double)FastColor.ARGB32.m_13669_((int)col) * 0.4);
        int i1 = FastColor.ARGB32.m_13660_((int)0, (int)colr, (int)colg, (int)colb);
        if (state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
            matrixStackIn.m_85837_(0.5, 0.359375, 0.859375);
        } else if (state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
            matrixStackIn.m_85837_(0.5, 0.359375, 0.140625);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        } else if (state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
            matrixStackIn.m_85837_(0.140625, 0.359375, 0.5);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
            matrixStackIn.m_85837_(0.859375, 0.359375, 0.5);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        }
        if (!(state.m_60734_() instanceof OwlCourierDepotWall)) {
            matrixStackIn.m_85837_(0.0, -0.3125, 0.0);
        }
        if (ClientOwlCourierDepotData.getDepots().containsKey(GlobalPos.m_122643_((ResourceKey)tileEntityIn.m_58904_().m_46472_(), (BlockPos)tileEntityIn.m_58899_()))) {
            int i;
            OwlCourierDepotData depotData = ClientOwlCourierDepotData.getDepots().get(GlobalPos.m_122643_((ResourceKey)tileEntityIn.m_58904_().m_46472_(), (BlockPos)tileEntityIn.m_58899_()));
            int packages = 0;
            int letters = 0;
            for (ItemStack stack : depotData.items) {
                if (stack.m_41720_() == ModItems.COURIER_PACKAGE.get()) {
                    ++packages;
                }
                if (stack.m_41720_() != ModItems.COURIER_LETTER.get()) continue;
                ++letters;
            }
            Random random = new Random(4200L);
            float packageOffset = 0.5f;
            for (i = 0; i < packages; ++i) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(-0.39375, (double)packageOffset / 16.0, -0.7625);
                matrixStackIn.m_85841_(0.8f, 0.8f, 0.8f);
                matrixStackIn.m_85837_(0.5, 0.0, 0.5);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((float)(random.nextInt(360) * i)));
                matrixStackIn.m_85837_(-0.5, 0.0, -0.5);
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((CourierPackage)ModBlocks.COURIER_PACKAGE.get()).m_49966_());
                matrixStackIn.m_85849_();
                packageOffset += 5.7f;
            }
            packageOffset += 0.1f;
            for (i = 0; i < letters; ++i) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_((-6.3 - (double)random.nextFloat(0.8f * (float)(letters - i)) + (double)(0.4f * (float)(letters - i))) / 16.0, (double)packageOffset / 16.0, (-12.2 - (double)random.nextFloat(0.8f * (float)(letters - i)) + (double)(0.4f * (float)(letters - i))) / 16.0);
                matrixStackIn.m_85841_(0.8f, 0.8f, 0.8f);
                matrixStackIn.m_85837_(0.5, 0.0, 0.5);
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_((float)(random.nextInt(360) * i)));
                matrixStackIn.m_85837_(-0.5, 0.0, -0.5);
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((CourierLetter)ModBlocks.COURIER_LETTER.get()).m_49966_());
                matrixStackIn.m_85849_();
                packageOffset += 0.2f;
            }
        }
        if (state.m_60734_() instanceof OwlCourierDepotWall) {
            matrixStackIn.m_85837_(0.0, -0.0625, 0.0);
        }
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-22.0f));
        matrixStackIn.m_85837_(0.0, 0.0625, 0.0);
        matrixStackIn.m_85841_(0.00694445f, -0.00694445f, 0.00694445f);
        MutableComponent component = Component.m_237113_((String)"").m_130948_(Style.f_131099_.m_178520_(0xAAAAAA));
        if (owlCourierDepotTile.m_8077_() && owlCourierDepotTile.m_7770_().getString().length() > 0) {
            component = owlCourierDepotTile.m_7770_();
        }
        if ((list = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)component, 512)).size() > 0) {
            int width = this.minecraft.f_91062_.m_92724_((FormattedCharSequence)list.get(0));
            Objects.requireNonNull(this.minecraft.f_91062_);
            float lineHeight = 9.0f / 2.0f;
            if (width > 70) {
                float percent = (float)width / 70.0f;
                matrixStackIn.m_85836_();
                matrixStackIn.m_85841_(1.0f / percent, 1.0f / percent, 1.0f / percent);
                Minecraft.m_91087_().f_91062_.m_168645_((FormattedCharSequence)list.get(0), (float)(-width) / 2.0f, lineHeight * percent, i1, 0x222222, matrixStackIn.m_85850_().m_252922_(), bufferIn, combinedLightIn);
                matrixStackIn.m_85849_();
            } else {
                Minecraft.m_91087_().f_91062_.m_168645_((FormattedCharSequence)list.get(0), (float)(-width) / 2.0f, lineHeight, i1, 0x222222, matrixStackIn.m_85850_().m_252922_(), bufferIn, combinedLightIn);
            }
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, null);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BlockState state, RenderType renderType, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, renderType, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, RenderType renderType, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    for (RenderType rt : bakedmodel.getRenderTypes(p_110913_, RandomSource.m_216335_((long)42L), modelData)) {
                        dispatcher.m_110937_().renderModel(p_110914_.m_85850_(), p_110915_.m_6299_(renderType != null ? renderType : RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, rt);
                    }
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

