/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.mixins;

import net.mehvahdjukaar.amendments.client.TumblingAnimation;
import net.mehvahdjukaar.amendments.common.ProjectileStats;
import net.mehvahdjukaar.amendments.common.entity.IVisualTransformationProvider;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.moonlight.api.entity.ParticleTrailEmitter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Snowball.class})
public abstract class SnowballMixin
extends ThrowableItemProjectile
implements IVisualTransformationProvider {
    @Unique
    private final ParticleTrailEmitter amendments$trailEmitter = ProjectileStats.makeSnowballTrialEmitter();
    @Unique
    private final TumblingAnimation amendments$tumblingAnimation = ProjectileStats.makeFasterTumbler();

    public SnowballMixin(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public Matrix4f amendments$getVisualTransformation(float partialTicks) {
        return new Matrix4f().rotate((Quaternionfc)this.amendments$tumblingAnimation.getRotation(partialTicks));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.amendments$trailEmitter.tick((Projectile)this, (p, v) -> {
                if (this.m_20069_()) {
                    return;
                }
                if ((double)this.f_19796_.m_188501_() < 0.85) {
                    return;
                }
                double gx = this.f_19796_.m_188583_() * 0.015;
                double gy = this.f_19796_.m_188583_() * 0.015;
                double gz = this.f_19796_.m_188583_() * 0.015;
                double px = this.f_19796_.m_216328_(-0.2, 0.2);
                double py = this.f_19796_.m_216328_(-0.2, 0.2);
                double pz = this.f_19796_.m_216328_(-0.2, 0.2);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, p.f_82479_ + px, p.f_82480_ + py + 0.1, p.f_82481_ + pz, gx, gy, gz);
            });
            if (ClientConfigs.PROJECTILE_TUMBLE.get().booleanValue()) {
                this.amendments$tumblingAnimation.tick(this.f_19796_);
            }
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")})
    protected void amendments$addFreezing(EntityHitResult result, CallbackInfo ci) {
        super.m_5790_(result);
        int freeze = CommonConfigs.SNOWBALL_FREEZE.get();
        Entity entity = result.m_82443_();
        if (freeze > 0 && !entity.m_6060_() && entity.m_142079_()) {
            int m = entity.m_146888_();
            entity.m_146917_(Math.min(entity.m_146891_(), m + freeze));
        }
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    protected void amendments$addParticles(byte id, CallbackInfo ci) {
        if (id == 3) {
            for (int i = 8; i > 0; --i) {
                double x = this.m_20208_(1.0);
                double y = this.m_20187_();
                double z = this.m_20262_(1.0);
                double vx = this.f_19796_.m_188583_() * 0.035;
                double vy = this.f_19796_.m_188583_() * 0.015 * 0.02;
                double vz = this.f_19796_.m_188583_() * 0.035;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, vx, vy, vz);
            }
        }
    }
}

