/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.rhino.mod.util.MinecraftRemapper;
import dev.latvian.mods.rhino.mod.util.MojangMappings;
import dev.latvian.mods.rhino.mod.util.RemapperException;
import dev.latvian.mods.rhino.mod.util.RhinoProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemappingHelper {
    public static final boolean GENERATE = System.getProperty("generaterhinomappings", "0").equals("1");
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Rhino Script Remapper");
    private static final Map<String, Optional<Class<?>>> CLASS_CACHE = new HashMap();
    private static MinecraftRemapper minecraftRemapper = null;

    private static Optional<Class<?>> loadClass(String name) {
        return switch (name) {
            case "void" -> {
                Optional<Class<Void>> var3_3;
                yield var3_3 = Optional.of(Void.TYPE);
            }
            case "boolean" -> {
                Optional<Class<Boolean>> var3_4 = Optional.of(Boolean.TYPE);
                yield var3_4;
            }
            case "char" -> {
                Optional<Class<Character>> var3_5 = Optional.of(Character.TYPE);
                yield var3_5;
            }
            case "byte" -> {
                Optional<Class<Byte>> var3_6 = Optional.of(Byte.TYPE);
                yield var3_6;
            }
            case "short" -> {
                Optional<Class<Short>> var3_7 = Optional.of(Short.TYPE);
                yield var3_7;
            }
            case "int" -> {
                Optional<Class<Integer>> var3_8 = Optional.of(Integer.TYPE);
                yield var3_8;
            }
            case "long" -> {
                Optional<Class<Long>> var3_9 = Optional.of(Long.TYPE);
                yield var3_9;
            }
            case "float" -> {
                Optional<Class<Float>> var3_10 = Optional.of(Float.TYPE);
                yield var3_10;
            }
            case "double" -> {
                Optional<Class<Double>> var3_11 = Optional.of(Double.TYPE);
                yield var3_11;
            }
            default -> {
                try {
                    Optional<Class<?>> var3_12 = Optional.of(Class.forName(name));
                    yield var3_12;
                }
                catch (Exception ex) {
                    Optional var3_13 = Optional.empty();
                    yield var3_13;
                }
            }
        };
    }

    public static Optional<Class<?>> getClass(String name) {
        return CLASS_CACHE.computeIfAbsent(name, RemappingHelper::loadClass);
    }

    public static MinecraftRemapper getMinecraftRemapper(boolean debug) {
        if (minecraftRemapper == null) {
            LOGGER.info("Loading Rhino Minecraft remapper...");
            long time = System.currentTimeMillis();
            Path configPath = RhinoProperties.getGameDir().resolve("config/mm.jsmappings");
            if (Files.exists(configPath, new LinkOption[0])) {
                try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(Objects.requireNonNull(Files.newInputStream(configPath, new OpenOption[0]))));){
                    minecraftRemapper = MinecraftRemapper.load(in, debug);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    LOGGER.error("Failed to load Rhino Minecraft remapper from config/mm.jsmappings!", (Throwable)ex);
                    minecraftRemapper = new MinecraftRemapper(Map.of(), Map.of());
                }
            } else {
                try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(Objects.requireNonNull(RhinoProperties.openResource("mm.jsmappings"))));){
                    minecraftRemapper = MinecraftRemapper.load(in, debug);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    LOGGER.error("Failed to load Rhino Minecraft remapper from mod jar!", (Throwable)ex);
                    minecraftRemapper = new MinecraftRemapper(Map.of(), Map.of());
                }
            }
            LOGGER.info(String.format("Done in %.03f s", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f)));
        }
        return minecraftRemapper;
    }

    public static MinecraftRemapper getMinecraftRemapper() {
        return RemappingHelper.getMinecraftRemapper(false);
    }

    public static Reader createReader(String url) throws Exception {
        LOGGER.info("Fetching " + url + "...");
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(10000);
        return new InputStreamReader((InputStream)new BufferedInputStream(connection.getInputStream()), StandardCharsets.UTF_8);
    }

    public static void run(String mcVersion, Callback callback) {
        try {
            RemappingHelper.generate(mcVersion, callback);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generate(String mcVersion, Callback callback) throws Exception {
        if (mcVersion.isEmpty()) {
            throw new RuntimeException("Invalid Minecraft version!");
        }
        if (RhinoProperties.isDev()) {
            RemappingHelper.getMinecraftRemapper(true);
            return;
        }
        try (Reader metaInfoReader = RemappingHelper.createReader("https://piston-meta.mojang.com/mc/game/version_manifest_v2.json");){
            for (JsonElement metaInfo : ((JsonObject)GSON.fromJson(metaInfoReader, JsonObject.class)).get("versions").getAsJsonArray()) {
                if (!metaInfo.getAsJsonObject().get("id").getAsString().equals(mcVersion)) continue;
                String metaUrl = metaInfo.getAsJsonObject().get("url").getAsString();
                Reader metaReader = RemappingHelper.createReader(metaUrl);
                try {
                    JsonObject cmap;
                    JsonObject o;
                    JsonObject meta = (JsonObject)GSON.fromJson(metaReader, JsonObject.class);
                    JsonElement jsonElement = meta.get("downloads");
                    if (!(jsonElement instanceof JsonObject) || !((jsonElement = (o = (JsonObject)jsonElement).get("client_mappings")) instanceof JsonObject) || !(cmap = (JsonObject)jsonElement).has("url")) throw new RemapperException("This Minecraft version doesn't have mappings!");
                    try (Reader cmapReader = RemappingHelper.createReader(cmap.get("url").getAsString());){
                        MojangMappings mojangMappings = MojangMappings.parse(mcVersion, IOUtils.readLines((Reader)cmapReader));
                        callback.generateMappings(new MappingContext(mcVersion, mojangMappings));
                        mojangMappings.cleanup();
                        try (BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(Files.newOutputStream(Path.of("mm.jsmappings", new String[0]), new OpenOption[0])));){
                            mojangMappings.write(out);
                        }
                        LOGGER.info("Finished generating mappings!");
                        return;
                    }
                }
                finally {
                    if (metaReader != null) {
                        metaReader.close();
                    }
                    throw new RemapperException("Failed for unknown reason!");
                }
            }
        }
    }

    public static void writeVarInt(OutputStream stream, int value) throws Exception {
        while ((value & 0xFFFFFF80) != 0) {
            stream.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        stream.write(value);
    }

    public static void writeUtf(OutputStream stream, String value) throws Exception {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        RemappingHelper.writeVarInt(stream, bytes.length);
        stream.write(bytes);
    }

    public static int readVarInt(InputStream stream) throws Exception {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = (byte)stream.read();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RemapperException("VarInt too big");
        } while ((b & 0x80) == 128);
        return i;
    }

    public static String readUtf(InputStream stream) throws Exception {
        byte[] bytes = new byte[RemappingHelper.readVarInt(stream)];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)stream.read();
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static interface Callback {
        public void generateMappings(MappingContext var1) throws Exception;
    }

    public record MappingContext(String mcVersion, MojangMappings mappings) {
    }
}

