/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.extern.paraglider;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.common.action.impl.BreakfallReady;
import com.alrex.parcool.common.action.impl.CatLeap;
import com.alrex.parcool.common.action.impl.ChargeJump;
import com.alrex.parcool.common.action.impl.ClimbUp;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.FastSwim;
import com.alrex.parcool.common.action.impl.HorizontalWallRun;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Vault;
import com.alrex.parcool.common.action.impl.VerticalWallRun;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerStateCondition;

public class ParCoolPlayerStates {
    public static final Entry FAST_RUN = new Entry(FastRun.class).parentID(ParagliderPlayerStates.IDLE).priority(3.0);
    public static final Entry FAST_SWIM = new Entry(FastSwim.class).parentID(ParagliderPlayerStates.SWIMMING);
    public static final Entry CLING_TO_CLIFF = new Entry(ClingToCliff.class);
    public static final Entry BREAKFALL = new Entry(BreakfallReady.class).condition((p, s, b, f) -> !p.m_21255_());
    public static final Entry DODGE = new Entry(Dodge.class).priority(4.0).parentID(ParagliderPlayerStates.IDLE, ParagliderPlayerStates.RUNNING);
    public static final Entry CLIMB_UP = new Entry(ClimbUp.class).parentID(CLING_TO_CLIFF.stateID());
    public static final Entry ROLL = new Entry(Roll.class).parentID(BREAKFALL.stateID()).condition((p, s, b, f) -> !p.m_21255_());
    public static final Entry HORIZONTAL_WALL_RUN = new Entry(HorizontalWallRun.class).parentID(ParagliderPlayerStates.MIDAIR);
    public static final Entry VERTICAL_WALL_RUN = new Entry(VerticalWallRun.class).parentID(ParagliderPlayerStates.MIDAIR);
    public static final Entry VAULT = new Entry(Vault.class).parentID(FAST_RUN.stateID());
    public static final Entry CATLEAP = new Entry(CatLeap.class).parentID(FAST_RUN.stateID());
    public static final Entry CHARGE_JUMP = new Entry(ChargeJump.class).parentID(ParagliderPlayerStates.MIDAIR);
    public static final List<Entry> ENTRIES = Arrays.asList(FAST_RUN, FAST_SWIM, CLING_TO_CLIFF, BREAKFALL, DODGE, CLIMB_UP, ROLL, HORIZONTAL_WALL_RUN, VERTICAL_WALL_RUN, VAULT, CATLEAP, CHARGE_JUMP);

    public record Entry(Class<? extends Action> clazz, ResourceLocation stateID, List<ResourceLocation> parentID, int staminaDelta, double priority, PlayerStateCondition condition) {
        private Entry(Class<? extends Action> clazz) {
            this(clazz, new ResourceLocation("parcool", clazz.getSimpleName().toLowerCase()), Collections.singletonList(ParagliderPlayerStates.IDLE), -Math.min(15, ActionList.ACTION_REGISTRIES.get(ActionList.getIndexOf(clazz)).getDefaultStaminaConsumption()), 0.0, (p, s, b, f) -> {
                Parkourability parkourability = Parkourability.get(p);
                if (parkourability == null) {
                    return false;
                }
                return parkourability.getClientInfo().getStaminaType() == IStamina.Type.Paraglider && ((Action)parkourability.get(clazz)).isDoing();
            });
        }

        public Entry condition(PlayerStateCondition condition) {
            return new Entry(this.clazz, this.stateID, this.parentID, this.staminaDelta, this.priority, (p, s, b, f) -> this.condition.test(p, s, b, f) && condition.test(p, s, b, f));
        }

        public Entry priority(double value) {
            return new Entry(this.clazz, this.stateID, this.parentID, this.staminaDelta, value, this.condition);
        }

        public Entry staminaDelta(int value) {
            return new Entry(this.clazz, this.stateID, this.parentID, value, this.priority, this.condition);
        }

        public Entry parentID(ResourceLocation ... value) {
            return new Entry(this.clazz, this.stateID, Arrays.stream(value).toList(), this.staminaDelta, this.priority, this.condition);
        }
    }
}

