/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.client.integration.emi.BlendTextureWidget;
import vazkii.botania.client.integration.emi.BotaniaEmiPlugin;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.client.integration.emi.ManaWidget;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TerrestrialAgglomerationEmiRecipe
extends BotaniaEmiRecipe {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.prefix("textures/gui/terrasteel_jei_overlay.png");
    private static final EmiStack PLATE = EmiStack.of((ItemLike)BotaniaBlocks.terraPlate);
    public static final int CENTER_X = 45;
    public static final int CENTER_Y = 30;
    private final int mana;

    public TerrestrialAgglomerationEmiRecipe(TerrestrialAgglomerationRecipe recipe) {
        super(BotaniaEmiPlugin.TERRESTRIAL_AGGLOMERATION, recipe);
        this.input = recipe.m_7527_().stream().map(EmiIngredient::of).toList();
        this.output = List.of(EmiStack.of((ItemStack)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_)));
        this.mana = recipe.getMana();
    }

    public int getDisplayHeight() {
        return 107;
    }

    public int getDisplayWidth() {
        return 106;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)new ManaWidget(2, 100, this.mana, 1000000));
        double step = 360.0 / (double)this.input.size();
        widgets.add((Widget)new BlendTextureWidget(TEXTURE, 22, 7, 64, 64, 42, 29));
        for (int i = 0; i < this.input.size(); ++i) {
            EmiIngredient ing = (EmiIngredient)this.input.get(i);
            widgets.addSlot(ing, BotaniaEmiPlugin.rotateXAround(45, 0, 45, 30, step * (double)i), BotaniaEmiPlugin.rotateYAround(45, 0, 45, 30, step * (double)i)).drawBack(false);
        }
        widgets.addSlot((EmiIngredient)PLATE, 45, 80).drawBack(false).catalyst(true);
        widgets.addSlot((EmiIngredient)this.output.get(0), 45, 30).drawBack(false).recipeContext((EmiRecipe)this);
    }
}

