/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;

public class PylonBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = PylonBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)21.0, (double)14.0);
    public final Variant variant;

    public PylonBlock(@NotNull Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PylonBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return PylonBlock.createTickerHelper(type, BotaniaBlockEntities.PYLON, PylonBlockEntity::commonTick);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        return this.variant.enchantPowerBonus;
    }

    public static enum Variant {
        MANA(8.0f, 0.5f, 0.5f, 1.0f),
        NATURA(15.0f, 0.5f, 1.0f, 0.5f),
        GAIA(15.0f, 1.0f, 0.5f, 1.0f);

        public final float enchantPowerBonus;
        public final float r;
        public final float g;
        public final float b;

        private Variant(float epb, float r, float g, float b) {
            this.enchantPowerBonus = epb;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public Block getTargetBlock() {
            return this == MANA ? BotaniaBlocks.enchanter : BotaniaBlocks.alfPortal;
        }
    }
}

