/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BlackHoleTalismanItem;
import vazkii.botania.common.item.BotaniaItems;

public class BlackHoleTalismanExtractRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<BlackHoleTalismanExtractRecipe> SERIALIZER = new NoOpRecipeSerializer<BlackHoleTalismanExtractRecipe>(BlackHoleTalismanExtractRecipe::new);

    public BlackHoleTalismanExtractRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.MISC);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundTalisman = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(BotaniaItems.blackHoleTalisman) && !foundTalisman) {
                int count = BlackHoleTalismanItem.getBlockCount(stack);
                if (count <= 0) {
                    return false;
                }
                foundTalisman = true;
                continue;
            }
            return false;
        }
        return foundTalisman;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        Block block;
        ItemStack talisman = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            talisman = stack;
        }
        int count = BlackHoleTalismanItem.getBlockCount(talisman);
        if (count > 0 && (block = BlackHoleTalismanItem.getBlock(talisman)) != null) {
            return new ItemStack((ItemLike)block, Math.min(64, count));
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 0;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer inv) {
        return RecipeUtils.getRemainingItemsSub((Container)inv, s -> {
            if (s.m_150930_(BotaniaItems.blackHoleTalisman)) {
                int count = BlackHoleTalismanItem.getBlockCount(s);
                if (count == 0) {
                    return ItemStack.f_41583_;
                }
                int extract = Math.min(64, count);
                ItemStack copy = s.m_255036_(1);
                BlackHoleTalismanItem.remove(copy, extract);
                ItemNBTHelper.setBoolean(copy, "active", false);
                return copy;
            }
            return null;
        });
    }
}

