/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaBlasterItem;

public class ManaBlasterRemoveLensRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<ManaBlasterRemoveLensRecipe> SERIALIZER = new NoOpRecipeSerializer<ManaBlasterRemoveLensRecipe>(ManaBlasterRemoveLensRecipe::new);

    public ManaBlasterRemoveLensRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundGun = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ManaBlasterItem && !ManaBlasterItem.getLens(stack).m_41619_() && !foundGun) {
                foundGun = true;
                continue;
            }
            return false;
        }
        return foundGun;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack gun = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ManaBlasterItem)) continue;
            gun = stack;
        }
        ItemStack gunCopy = gun.m_255036_(1);
        ManaBlasterItem.setLens(gunCopy, ItemStack.f_41583_);
        return gunCopy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 0;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer inv) {
        return RecipeUtils.getRemainingItemsSub((Container)inv, s -> {
            if (s.m_150930_(BotaniaItems.manaGun)) {
                ItemStack stack = ManaBlasterItem.getLens(s);
                stack.m_41764_(1);
                return stack;
            }
            return null;
        });
    }
}

