/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPumpBlockEntity;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaPoolMinecartEntity
extends AbstractMinecart {
    private static final int TRANSFER_RATE = 10000;
    private static final String TAG_MANA = "mana";
    private static final EntityDataAccessor<Integer> MANA = SynchedEntityData.m_135353_(ManaPoolMinecartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ManaPoolMinecartEntity(EntityType<ManaPoolMinecartEntity> type, Level world) {
        super(type, world);
    }

    public ManaPoolMinecartEntity(Level world, double x, double y, double z) {
        super(BotaniaEntities.POOL_MINECART, world, x, y, z);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MANA, (Object)0);
    }

    @NotNull
    public BlockState m_38178_() {
        return BotaniaBlocks.manaPool.m_49966_();
    }

    @NotNull
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    protected boolean m_7310_(Entity passenger) {
        return false;
    }

    protected void m_7114_() {
        float f = 0.98f;
        this.m_20256_(this.m_20184_().m_82542_((double)f, 0.0, (double)f));
    }

    @NotNull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)BotaniaItems.poolMinecart);
    }

    public int m_7144_() {
        return 8;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            double particleChance = 1.0 - (double)this.getMana() / 1000000.0 * 0.1;
            int color = 50943;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            double x = Mth.m_14107_((double)this.m_20185_());
            double y = Mth.m_14107_((double)this.m_20186_());
            double z = Mth.m_14107_((double)this.m_20189_());
            if (Math.random() > particleChance) {
                WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, red, green, blue, 2.0f);
                this.m_9236_().m_7106_((ParticleOptions)data, x + 0.3 + Math.random() * 0.5, y + 0.85 + Math.random() * 0.25, z + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
            }
        }
    }

    public void m_6401_(BlockPos pos, BlockState state) {
        super.m_6401_(pos, state);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos pumpPos = pos.m_121945_(dir);
            BlockState pumpState = this.m_9236_().m_8055_(pumpPos);
            if (!pumpState.m_60713_(BotaniaBlocks.pump)) continue;
            ManaPumpBlockEntity pump = (ManaPumpBlockEntity)this.m_9236_().m_7702_(pumpPos);
            BlockPos poolPos = pumpPos.m_121945_(dir);
            ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(this.m_9236_(), poolPos, dir.m_122424_());
            if (!(receiver instanceof ManaPool)) continue;
            ManaPool pool = (ManaPool)receiver;
            Direction pumpDir = (Direction)pumpState.m_61143_((Property)BlockStateProperties.f_61374_);
            boolean did = false;
            boolean can = false;
            if (pumpDir == dir) {
                int poolMana;
                int transfer;
                int actualTransfer;
                can = true;
                if (!pump.hasRedstone && (actualTransfer = Math.min(1000000 - (cartMana = this.getMana()), transfer = Math.min(10000, poolMana = pool.getCurrentMana()))) > 0) {
                    pool.receiveMana(-transfer);
                    this.setMana(cartMana + actualTransfer);
                    did = true;
                }
            } else if (pumpDir == dir.m_122424_()) {
                int transfer;
                can = true;
                if (!pump.hasRedstone && !pool.isFull() && (transfer = Math.min(10000, cartMana = this.getMana())) > 0) {
                    pool.receiveMana(transfer);
                    this.setMana(cartMana - transfer);
                    did = true;
                }
            }
            if (did) {
                pump.hasCart = true;
                pump.setActive(true);
            }
            if (!can) continue;
            pump.hasCartOnTop = true;
            pump.comparator = (int)((double)this.getMana() / 1000000.0 * 15.0);
        }
    }

    protected void m_7380_(@NotNull CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128405_(TAG_MANA, this.getMana());
    }

    protected void m_7378_(CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setMana(cmp.m_128451_(TAG_MANA));
    }

    public Item m_213728_() {
        return BotaniaItems.poolMinecart;
    }

    public int getComparatorLevel() {
        return ManaPoolBlockEntity.calculateComparatorLevel(this.getMana(), 1000000);
    }

    public int getMana() {
        return (Integer)this.f_19804_.m_135370_(MANA);
    }

    public void setMana(int mana) {
        this.f_19804_.m_135381_(MANA, (Object)mana);
    }
}

