/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.internal_caps;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.common.internal_caps.SerializableComponent;

public class LooniumComponent
extends SerializableComponent {
    protected static final String TAG_TO_DROP = "toDrop";
    protected static final String TAG_OVERRIDE_DROP = "overrideDrop";
    protected static final String TAG_SLOW_DESPAWN = "slowDespawn";
    private ItemStack toDrop = ItemStack.f_41583_;
    private boolean overrideDrop;
    private boolean slowDespawn;

    public ItemStack getDrop() {
        return this.toDrop;
    }

    public void setDrop(ItemStack stack) {
        this.toDrop = stack;
    }

    public boolean isOverrideDrop() {
        return this.overrideDrop;
    }

    public void setOverrideDrop(boolean overrideDrop) {
        this.overrideDrop = overrideDrop;
    }

    public boolean isSlowDespawn() {
        return this.slowDespawn;
    }

    public void setSlowDespawn(boolean slowDespawn) {
        this.slowDespawn = slowDespawn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LooniumComponent)) return false;
        LooniumComponent component = (LooniumComponent)obj;
        if (!ItemStack.m_41728_((ItemStack)component.toDrop, (ItemStack)this.toDrop)) return false;
        if (component.overrideDrop != this.overrideDrop) return false;
        if (component.slowDespawn != this.slowDespawn) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.toDrop.hashCode(), this.overrideDrop, this.slowDespawn);
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        if (tag.m_128441_(TAG_TO_DROP)) {
            this.setDrop(ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_TO_DROP)));
        } else {
            this.setDrop(ItemStack.f_41583_);
        }
        if (tag.m_128441_(TAG_OVERRIDE_DROP)) {
            this.setOverrideDrop(tag.m_128471_(TAG_OVERRIDE_DROP));
        }
        if (tag.m_128441_(TAG_SLOW_DESPAWN)) {
            this.setSlowDespawn(tag.m_128471_(TAG_SLOW_DESPAWN));
        }
    }

    @Override
    public void writeToNbt(CompoundTag tag) {
        if (this.isOverrideDrop()) {
            if (!this.getDrop().m_41619_()) {
                tag.m_128365_(TAG_TO_DROP, (Tag)this.getDrop().m_41739_(new CompoundTag()));
            }
            tag.m_128379_(TAG_OVERRIDE_DROP, true);
        }
        if (this.isSlowDespawn()) {
            tag.m_128379_(TAG_SLOW_DESPAWN, true);
        }
    }
}

