/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.helper.ItemNBTHelper;

public class BottledManaItem
extends Item {
    public static final int SWIGS = 6;
    private static final String TAG_SWIGS_LEFT = "swigsLeft";
    private static final String TAG_SEED = "randomSeed";
    private static final EffectAction[] EFFECT_ACTIONS = new EffectAction[]{BottledManaItem::effectRandomMotion, BottledManaItem::effectWater, BottledManaItem::effectSetOnFire, BottledManaItem::effectMiniExplosion, BottledManaItem::effectMegaJump, BottledManaItem::effectSetRandomHp, BottledManaItem::effectLotsOfHearts, BottledManaItem::effectDropAllItems, BottledManaItem::effectBreakNeck, BottledManaItem::effectHighestPossible, BottledManaItem::effectHyperspeed, BottledManaItem::effectNightVision, BottledManaItem::effectPixieFriend, BottledManaItem::effectNauseaBlindness, BottledManaItem::effectDropOwnHead};

    public BottledManaItem(Item.Properties props) {
        super(props);
    }

    private static void effectRandomMotion(Level level, LivingEntity living) {
        living.m_20334_((Math.random() - 0.5) * 3.0, living.m_20184_().m_7098_(), (Math.random() - 0.5) * 3.0);
    }

    private static void effectWater(Level level, LivingEntity living) {
        if (!level.f_46443_ && !level.m_6042_().f_63857_()) {
            BlockState replacedState;
            BlockPos waterPos;
            LiquidBlockContainer lbc;
            Block block;
            BlockPos playerPos = living.m_20183_();
            BlockState state = level.m_8055_(playerPos);
            if (state.m_60795_() || state.m_60722_((Fluid)Fluids.f_76193_) || (block = state.m_60734_()) instanceof LiquidBlockContainer && (lbc = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, playerPos, state, (Fluid)Fluids.f_76193_)) {
                waterPos = playerPos;
                replacedState = state;
            } else {
                LiquidBlockContainer lbc2;
                Block block2;
                BlockState aboveState = level.m_8055_(playerPos.m_7494_());
                waterPos = aboveState.m_60795_() || aboveState.m_60722_((Fluid)Fluids.f_76193_) || (block2 = aboveState.m_60734_()) instanceof LiquidBlockContainer && (lbc2 = (LiquidBlockContainer)block2).m_6044_((BlockGetter)level, playerPos.m_7494_(), aboveState, (Fluid)Fluids.f_76193_) ? playerPos.m_7494_() : null;
                replacedState = aboveState;
            }
            if (waterPos != null) {
                boolean placed;
                Block block3 = replacedState.m_60734_();
                if (block3 instanceof LiquidBlockContainer) {
                    LiquidBlockContainer lbc3 = (LiquidBlockContainer)block3;
                    placed = lbc3.m_7361_((LevelAccessor)level, waterPos, replacedState, Fluids.f_76193_.m_76068_(false));
                } else {
                    if (replacedState.m_60722_((Fluid)Fluids.f_76193_)) {
                        level.m_46961_(waterPos, true);
                    }
                    placed = level.m_46597_(waterPos, Blocks.f_49990_.m_49966_());
                }
                if (placed) {
                    level.m_245803_((Entity)living, waterPos, SoundEvents.f_12540_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() + 0.5f);
                }
            }
        }
    }

    private static void effectSetOnFire(Level level, LivingEntity living) {
        if (!level.f_46443_) {
            living.m_20254_(4);
        }
    }

    private static void effectMiniExplosion(Level level, LivingEntity living) {
        if (!level.f_46443_) {
            level.m_254849_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), 0.25f, Level.ExplosionInteraction.NONE);
        }
    }

    private static void effectMegaJump(Level level, LivingEntity living) {
        if (!level.m_6042_().f_63857_()) {
            if (!level.f_46443_) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 5));
            }
            living.m_20334_(living.m_20184_().m_7096_(), 6.0, living.m_20184_().m_7094_());
        }
    }

    private static void effectSetRandomHp(Level level, LivingEntity living) {
        if (!level.f_46443_) {
            float nextHealth = (float)(Math.random() * (double)living.m_21233_());
            if (Mth.m_14033_((float)nextHealth, (float)0.0f)) {
                nextHealth = 0.5f;
            }
            living.m_21153_(nextHealth);
        }
    }

    private static void effectLotsOfHearts(Level level, LivingEntity living) {
        if (!level.f_46443_) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 2400, 9));
        }
    }

    private static void effectBreakNeck(Level level, LivingEntity living) {
        living.m_146926_((float)Math.random() * 360.0f);
        living.m_146922_((float)Math.random() * 180.0f);
    }

    private static void effectHighestPossible(Level level, LivingEntity living) {
        int x = Mth.m_14107_((double)living.m_20185_());
        int z = Mth.m_14107_((double)living.m_20189_());
        for (int i = level.m_151558_(); i > level.m_141937_(); --i) {
            BlockState state = level.m_8055_(new BlockPos(x, i, z));
            if (state.m_60795_()) continue;
            living.m_6021_(living.m_20185_(), (double)i, living.m_20189_());
            break;
        }
    }

    private static void effectDropAllItems(Level level, LivingEntity living) {
        if (!level.f_46443_ && living instanceof Player) {
            Player player = (Player)living;
            player.m_150109_().m_36071_();
        }
    }

    private static void effectHyperspeed(Level level, LivingEntity living) {
        if (!level.f_46443_) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 200));
        }
    }

    private static void effectNightVision(Level level, LivingEntity living) {
        if (!level.f_46443_) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 6000, 0));
        }
    }

    private static void effectPixieFriend(Level level, LivingEntity living) {
        if (!level.f_46443_) {
            PixieEntity pixie = new PixieEntity(level);
            pixie.m_6034_(living.m_20185_(), living.m_20186_() + 1.5, living.m_20189_());
            level.m_7967_((Entity)pixie);
        }
    }

    private static void effectNauseaBlindness(Level level, LivingEntity living) {
        if (!level.f_46443_) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 160, 3));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 160, 0));
        }
    }

    private static void effectDropOwnHead(Level level, LivingEntity living) {
        if (!level.f_46443_ && living instanceof Player) {
            Player player = (Player)living;
            living.m_6469_(living.m_269291_().m_269425_(), living.m_21223_() - 1.0f);
            ItemStack skull = new ItemStack((ItemLike)Items.f_42680_);
            ItemNBTHelper.setString(skull, "SkullOwner", player.m_36316_().getName());
            living.m_5552_(skull, 0.0f);
        }
    }

    private long getSeed(ItemStack stack) {
        long seed = ItemNBTHelper.getLong(stack, TAG_SEED, -1L);
        if (seed == -1L) {
            return this.randomSeed(stack);
        }
        return seed;
    }

    private long randomSeed(ItemStack stack) {
        long seed = Math.abs(ThreadLocalRandom.current().nextLong());
        ItemNBTHelper.setLong(stack, TAG_SEED, seed);
        return seed;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        stacks.add((Component)Component.m_237115_((String)"botaniamisc.bottleTooltip"));
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, Level world, LivingEntity living) {
        EFFECT_ACTIONS[new Random(this.getSeed(stack)).nextInt(EFFECT_ACTIONS.length)].apply(world, living);
        int left = BottledManaItem.getSwigsLeft(stack);
        if (left <= 1) {
            stack.m_41764_(0);
            return new ItemStack((ItemLike)Items.f_42590_);
        }
        this.setSwigsLeft(stack, left - 1);
        this.randomSeed(stack);
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 20;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public static int getSwigsLeft(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, 6);
    }

    private void setSwigsLeft(ItemStack stack, int swigs) {
        ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
    }

    @FunctionalInterface
    private static interface EffectAction {
        public void apply(Level var1, LivingEntity var2);
    }
}

