/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.Relic;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public abstract class RelicBaubleItem
extends BaubleItem {
    public RelicBaubleItem(Item.Properties props) {
        super(props);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean held) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        RelicImpl.addDefaultTooltip(stack, tooltip);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity entity) {
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic != null && entity instanceof Player) {
            Player ePlayer = (Player)entity;
            relic.tickBinding(ePlayer);
            if (relic.isRightPlayer(ePlayer)) {
                this.onValidPlayerWornTick(ePlayer);
            }
        }
    }

    public void onValidPlayerWornTick(Player player) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canEquip(ItemStack stack, LivingEntity entity) {
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (relic == null) return false;
        if (!relic.isRightPlayer(player)) return false;
        return true;
    }
}

