/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.forge.data.ForgeBlockTagProvider;

public class ForgeItemTagProvider
extends ItemTagsProvider {
    public ForgeItemTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, ExistingFileHelper helper) {
        super(packOutput, lookupProvider, blockTagProvider, "botania", helper);
    }

    public String m_6055_() {
        return "Botania item tags (Forge-specific)";
    }

    protected void m_6577_(HolderLookup.Provider provider) {
        this.m_206424_(ForgeItemTagProvider.forge("dusts/mana")).m_206428_(BotaniaTags.Items.DUSTS_MANA);
        this.m_206424_(ForgeItemTagProvider.forge("dusts")).m_206428_(ForgeItemTagProvider.forge("dusts/mana"));
        this.m_206424_(ForgeItemTagProvider.forge("gems/dragonstone")).m_206428_(BotaniaTags.Items.GEMS_DRAGONSTONE);
        this.m_206424_(ForgeItemTagProvider.forge("gems/mana_diamond")).m_206428_(BotaniaTags.Items.GEMS_MANA_DIAMOND);
        this.m_206424_(ForgeItemTagProvider.forge("gems")).m_206428_(ForgeItemTagProvider.forge("gems/dragonstone")).m_206428_(ForgeItemTagProvider.forge("gems/mana_diamond"));
        this.m_206424_(ForgeItemTagProvider.forge("ingots/elementium")).m_206428_(BotaniaTags.Items.INGOTS_ELEMENTIUM);
        this.m_206424_(ForgeItemTagProvider.forge("ingots/manasteel")).m_206428_(BotaniaTags.Items.INGOTS_MANASTEEL);
        this.m_206424_(ForgeItemTagProvider.forge("ingots/terrasteel")).m_206428_(BotaniaTags.Items.INGOTS_TERRASTEEL);
        this.m_206424_(ForgeItemTagProvider.forge("ingots")).m_206428_(ForgeItemTagProvider.forge("ingots/elementium")).m_206428_(ForgeItemTagProvider.forge("ingots/manasteel")).m_206428_(ForgeItemTagProvider.forge("ingots/terrasteel"));
        this.m_206424_(ForgeItemTagProvider.forge("nuggets/elementium")).m_206428_(BotaniaTags.Items.NUGGETS_ELEMENTIUM);
        this.m_206424_(ForgeItemTagProvider.forge("nuggets/manasteel")).m_206428_(BotaniaTags.Items.NUGGETS_MANASTEEL);
        this.m_206424_(ForgeItemTagProvider.forge("nuggets/terrasteel")).m_206428_(BotaniaTags.Items.NUGGETS_TERRASTEEL);
        this.m_206424_(ForgeItemTagProvider.forge("nuggets")).m_206428_(ForgeItemTagProvider.forge("nuggets/elementium")).m_206428_(ForgeItemTagProvider.forge("nuggets/manasteel")).m_206428_(ForgeItemTagProvider.forge("nuggets/terrasteel"));
        this.m_206424_(Tags.Items.HEADS).m_255245_((Object)BotaniaBlocks.gaiaHead.m_5456_());
        this.copyToSameName(ForgeBlockTagProvider.ELEMENTIUM);
        this.copyToSameName(ForgeBlockTagProvider.MANASTEEL);
        this.copyToSameName(ForgeBlockTagProvider.TERRASTEEL);
        this.copyToSameName(ForgeBlockTagProvider.MANA_DIAMOND);
        this.copyToSameName(ForgeBlockTagProvider.DRAGONSTONE);
        this.copyToSameName(ForgeBlockTagProvider.BLAZE_MESH);
        ColorHelper.supportedColors().map(ForgeBlockTagProvider.PETAL_BLOCKS::get).forEach(this::copyToSameName);
        this.m_206421_(ForgeBlockTagProvider.MUSHROOMS, Tags.Items.MUSHROOMS);
        this.m_206421_(Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Tags.Items.STORAGE_BLOCKS_QUARTZ);
        this.m_206421_(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS);
        this.m_206421_(Tags.Blocks.GLASS, Tags.Items.GLASS);
        this.m_206421_(Tags.Blocks.GLASS_PANES, Tags.Items.GLASS_PANES);
        this.m_206421_(Tags.Blocks.FENCES_WOODEN, Tags.Items.FENCES_WOODEN);
        this.m_206421_(Tags.Blocks.FENCE_GATES_WOODEN, Tags.Items.FENCE_GATES_WOODEN);
        this.m_206424_(BotaniaTags.Items.LENS_GLUE).m_206428_(Tags.Items.SLIMEBALLS).m_255245_((Object)Items.f_42787_);
        this.generateToolTags();
        this.generateAccessoryTags();
        this.generateQuarkTags();
    }

    private void generateToolTags() {
        this.m_206424_(Tags.Items.SHEARS).m_255179_((Object[])new Item[]{BotaniaItems.manasteelShears, BotaniaItems.elementiumShears});
        this.m_206424_(Tags.Items.TOOLS_BOWS).m_255179_((Object[])new Item[]{BotaniaItems.livingwoodBow, BotaniaItems.crystalBow});
        this.m_206424_(Tags.Items.ARMORS_HELMETS).m_255179_((Object[])new Item[]{BotaniaItems.manasteelHelm, BotaniaItems.manaweaveHelm, BotaniaItems.elementiumHelm, BotaniaItems.terrasteelHelm});
        this.m_206424_(Tags.Items.ARMORS_CHESTPLATES).m_255179_((Object[])new Item[]{BotaniaItems.manasteelChest, BotaniaItems.manaweaveChest, BotaniaItems.elementiumChest, BotaniaItems.terrasteelChest});
        this.m_206424_(Tags.Items.ARMORS_LEGGINGS).m_255179_((Object[])new Item[]{BotaniaItems.manasteelLegs, BotaniaItems.manaweaveLegs, BotaniaItems.elementiumLegs, BotaniaItems.terrasteelLegs});
        this.m_206424_(Tags.Items.ARMORS_BOOTS).m_255179_((Object[])new Item[]{BotaniaItems.manasteelBoots, BotaniaItems.manaweaveBoots, BotaniaItems.elementiumBoots, BotaniaItems.terrasteelBoots});
    }

    private void generateAccessoryTags() {
        this.m_206424_(ForgeItemTagProvider.accessory("belt")).m_255179_((Object[])new Item[]{BotaniaItems.knockbackBelt, BotaniaItems.speedUpBelt, BotaniaItems.superTravelBelt, BotaniaItems.travelBelt});
        this.m_206424_(ForgeItemTagProvider.accessory("body")).m_255179_((Object[])new Item[]{BotaniaItems.balanceCloak, BotaniaItems.holyCloak, BotaniaItems.invisibilityCloak, BotaniaItems.thirdEye, BotaniaItems.unholyCloak});
        this.m_206424_(ForgeItemTagProvider.accessory("charm")).m_255179_((Object[])new Item[]{BotaniaItems.divaCharm, BotaniaItems.goddessCharm, BotaniaItems.monocle, BotaniaItems.tinyPlanet});
        this.m_206424_(ForgeItemTagProvider.accessory("head")).m_255179_((Object[])new Item[]{BotaniaItems.flightTiara, BotaniaItems.itemFinder});
        this.m_206424_(ForgeItemTagProvider.accessory("necklace")).m_255179_((Object[])new Item[]{BotaniaItems.bloodPendant, BotaniaItems.cloudPendant, BotaniaItems.icePendant, BotaniaItems.lavaPendant, BotaniaItems.superCloudPendant, BotaniaItems.superLavaPendant});
        this.m_206424_(ForgeItemTagProvider.accessory("ring")).m_255179_((Object[])new Item[]{BotaniaItems.auraRing, BotaniaItems.auraRingGreater, BotaniaItems.dodgeRing, BotaniaItems.lokiRing, BotaniaItems.magnetRing, BotaniaItems.magnetRingGreater, BotaniaItems.manaRing, BotaniaItems.manaRingGreater, BotaniaItems.miningRing, BotaniaItems.odinRing, BotaniaItems.pixieRing, BotaniaItems.reachRing, BotaniaItems.swapRing, BotaniaItems.thorRing, BotaniaItems.waterRing});
        this.m_206424_(ForgeItemTagProvider.accessory("curio")).m_255179_((Object[])new Item[]{BotaniaItems.blackBowtie, BotaniaItems.blackTie, BotaniaItems.redGlasses, BotaniaItems.puffyScarf, BotaniaItems.engineerGoggles, BotaniaItems.eyepatch, BotaniaItems.wickedEyepatch, BotaniaItems.redRibbons, BotaniaItems.pinkFlowerBud, BotaniaItems.polkaDottedBows, BotaniaItems.blueButterfly, BotaniaItems.catEars, BotaniaItems.witchPin, BotaniaItems.devilTail, BotaniaItems.kamuiEye, BotaniaItems.googlyEyes, BotaniaItems.fourLeafClover, BotaniaItems.clockEye, BotaniaItems.unicornHorn, BotaniaItems.devilHorns, BotaniaItems.hyperPlus, BotaniaItems.botanistEmblem, BotaniaItems.ancientMask, BotaniaItems.eerieMask, BotaniaItems.alienAntenna, BotaniaItems.anaglyphGlasses, BotaniaItems.orangeShades, BotaniaItems.grouchoGlasses, BotaniaItems.thickEyebrows, BotaniaItems.lusitanicShield, BotaniaItems.tinyPotatoMask, BotaniaItems.questgiverMark, BotaniaItems.thinkingHand});
    }

    private void generateQuarkTags() {
        this.m_206424_(ForgeItemTagProvider.quark("big_harvest_hoes")).m_255245_((Object)BotaniaItems.elementiumHoe);
        this.m_206424_(ForgeItemTagProvider.quark("reacharound_able")).m_255179_((Object[])new Item[]{BotaniaItems.dirtRod, BotaniaItems.cobbleRod, BotaniaItems.blackHoleTalisman});
    }

    private static TagKey<Item> accessory(String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("curios", name));
    }

    private static TagKey<Item> forge(String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
    }

    private static TagKey<Item> quark(String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("quark", name));
    }

    private void copyToSameName(TagKey<Block> source) {
        this.m_206421_(source, ItemTags.create((ResourceLocation)source.f_203868_()));
    }
}

