/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.handler;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.mixin.accessor.CraftingResultSlotAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;

public class CoercedRecipeHandler<T extends AbstractContainerMenu>
implements StandardRecipeHandler<T> {
    private ResultSlot output;
    private CraftingContainer inv;

    public CoercedRecipeHandler(ResultSlot output) {
        this.output = output;
        this.inv = ((CraftingResultSlotAccessor)output).getInput();
    }

    @Override
    public Slot getOutputSlot(AbstractContainerMenu handler) {
        return this.output;
    }

    @Override
    public List<Slot> getInputSources(AbstractContainerMenu handler) {
        Minecraft client = Minecraft.m_91087_();
        ArrayList slots = Lists.newArrayList();
        if (this.output != null) {
            for (Slot slot : handler.f_38839_) {
                if (!slot.m_6659_() || !slot.m_8010_((Player)client.f_91074_) || slot == this.output) continue;
                slots.add(slot);
            }
        }
        return slots;
    }

    @Override
    public List<Slot> getCraftingSlots(AbstractContainerMenu handler) {
        ArrayList slots = Lists.newArrayList();
        int width = this.inv.m_39347_();
        int height = this.inv.m_39346_();
        for (int i = 0; i < 9; ++i) {
            slots.add(null);
        }
        for (Slot slot : handler.f_38839_) {
            if (slot.f_40218_ != this.inv || slot.m_150661_() >= width * height || slot.m_150661_() < 0) continue;
            int index = slot.m_150661_();
            index = index * 3 / width;
            slots.set(index, slot);
        }
        return slots;
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree()) {
            if (recipe instanceof EmiCraftingRecipe) {
                EmiCraftingRecipe crafting = (EmiCraftingRecipe)recipe;
                return crafting.canFit(this.inv.m_39347_(), this.inv.m_39346_());
            }
            return true;
        }
        return false;
    }
}

