/*
 * Decompiled with CFR 0.152.
 */
package com.periut.chisel.gui;

import com.periut.chisel.Chisel;
import com.periut.chisel.gui.BigSlot;
import com.periut.chisel.inventory.ChiselInventory;
import com.periut.chisel.inventory.InventoryUtil;
import com.periut.chisel.item.ChiselItem;
import com.periut.cryonicconfig.CryonicConfig;
import java.time.LocalTime;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChiselScreenHandler
extends AbstractContainerMenu {
    boolean compactTexture;
    private final ChiselInventory inventory;
    LocalTime currentTime = LocalTime.now();

    public ChiselScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, new ChiselInventory());
    }

    public ChiselScreenHandler(int syncId, Inventory playerInventory, Container inventory) {
        this(syncId, playerInventory, inventory, new CompoundTag());
    }

    public ChiselScreenHandler(int syncId, Inventory playerInventory, Container inventory, CompoundTag compound) {
        super((MenuType)Chisel.CHISEL_SCREEN_HANDLER.get(), syncId);
        this.compactTexture = CryonicConfig.getConfig((String)"chisel").getBoolean("compact_chisel_gui", false);
        ChiselScreenHandler.m_38869_((Container)inventory, (int)61);
        this.inventory = (ChiselInventory)inventory;
        if (this.compactTexture) {
            int y;
            int x;
            this.m_38897_(new Slot(inventory, 0, 8, 145));
            for (x = 0; x < 10; ++x) {
                for (y = 0; y < 6; ++y) {
                    this.m_38897_(new SlotChiselOutput(inventory, 1 + x + 10 * y, 62 + 18 * x - 54, 8 + 18 * y + 7));
                }
            }
            for (x = 0; x < 9; ++x) {
                for (y = 0; y < 3; ++y) {
                    this.m_38897_(new Slot((Container)playerInventory, 9 + x + 9 * y, 71 + 18 * x - 45, 120 + 18 * y + 7));
                }
            }
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x, 71 + 18 * x - 45, 185));
            }
        } else {
            int y;
            int x;
            this.m_38897_(((BigSlot)new Slot(inventory, 0, 24, 24)).setBigSlot(true));
            for (x = 0; x < 10; ++x) {
                for (y = 0; y < 6; ++y) {
                    this.m_38897_(new SlotChiselOutput(inventory, 1 + x + 10 * y, 62 + 18 * x, 8 + 18 * y));
                }
            }
            for (x = 0; x < 9; ++x) {
                for (y = 0; y < 3; ++y) {
                    this.m_38897_(new Slot((Container)playerInventory, 9 + x + 9 * y, 71 + 18 * x, 120 + 18 * y));
                }
            }
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x, 71 + 18 * x, 178));
            }
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int invSlot) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(invSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (originalStack.m_41720_().equals(Chisel.chiselSupplier.get())) {
                return ItemStack.f_41583_;
            }
            if (invSlot < this.inventory.m_6643_()) {
                if (invSlot != 0) {
                    int count;
                    if (((Slot)this.f_38839_.get(0)).m_6657_() && (count = ((Slot)this.f_38839_.get(0)).m_7993_().m_41613_()) > 0 && count <= 99) {
                        originalStack.m_41764_(count);
                    }
                    ChiselItem.chiselSound(player.m_9236_(), player.m_20183_());
                }
                if (!this.m_38903_(originalStack, this.inventory.m_6643_(), this.f_38839_.size(), true)) {
                    this.inventory.refresh(((Slot)this.f_38839_.get(0)).m_7993_().m_41720_());
                    return ItemStack.f_41583_;
                }
                this.inventory.m_6211_();
            } else if (!this.m_38903_(originalStack, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        ItemStack hand = (ItemStack)player.m_6167_().iterator().next();
        if (!hand.m_150930_((Item)Chisel.chiselSupplier.get())) {
            ItemStack chiselStack = ItemStack.f_41583_;
            int chiselSlot = -1;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                if (!player.m_150109_().m_8020_(i).m_150930_((Item)Chisel.chiselSupplier.get())) continue;
                chiselStack = player.m_150109_().m_8020_(i);
                chiselSlot = i;
                break;
            }
            player.m_150109_().m_6836_(0, chiselStack);
        }
        hand.m_41784_().m_128391_(InventoryUtil.createCompound(this.inventory));
    }

    public void m_150399_(int i, int j, ClickType actionType, Player playerEntity) {
        Slot slot;
        if (i >= 0 && i < this.f_38839_.size() && (slot = (Slot)this.f_38839_.get(i)).m_7993_().m_41720_() instanceof ChiselItem) {
            return;
        }
        super.m_150399_(i, j, actionType, playerEntity);
    }

    private static class SlotChiselOutput
    extends Slot {
        public SlotChiselOutput(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public void m_142406_(Player player, ItemStack stack) {
            this.f_40218_.m_6211_();
            super.m_142406_(player, stack);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public int m_6641_() {
            return 64;
        }
    }
}

