/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuAquaticPlacements;
import net.regions_unexplored.data.worldgen.placement.RuMiscOverworldPlacements;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class WetBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseSwampSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 1, 1, 1));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 25, 8, 8));
        return spawnBuilder;
    }

    private static MobSpawnSettings.Builder baseJungleSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 1));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseSwampGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean hasLilyPads, boolean hasFlowers) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomeBuilder);
        if (hasFlowers) {
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195417_);
        }
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        if (hasLilyPads) {
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195466_);
        }
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195412_);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195413_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126753_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195222_);
        return biomeBuilder;
    }

    private static BiomeGenerationSettings.Builder baseJungleGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean sparseMelons) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_198933_((BiomeGenerationSettings.Builder)biomeBuilder);
        if (sparseMelons) {
            BiomeDefaultFeatures.m_198931_((BiomeGenerationSettings.Builder)biomeBuilder);
        } else {
            BiomeDefaultFeatures.m_198929_((BiomeGenerationSettings.Builder)biomeBuilder);
        }
        return biomeBuilder;
    }

    public static Biome bayou(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(-6110795).m_48019_(-5124939).m_48034_(-12354486).m_48037_(-10450614).m_48043_(-9333940).m_48045_(-8609196).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.01f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215730_));
        BiomeGenerationSettings.Builder biomeBuilder = WetBiomes.baseSwampGeneration(featureGetter, carverGetter, false, true);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.CYPRESS_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.WILLOW_TREE_VINES);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        RuBiomeDefaultFeatures.addBayouVegetation(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ELEPHANT_EAR_SPARSE);
        MobSpawnSettings.Builder spawnBuilder = WetBiomes.baseSwampSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(1.0f).m_47611_(1.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome eucalyptusForest(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(WetBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(8828203).m_48045_(9680182).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_283786_));
        BiomeGenerationSettings.Builder biomeBuilder = WetBiomes.baseJungleGeneration(featureGetter, carverGetter, true);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.EUCALYPTUS_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.SMALL_EUCALYPTUS_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_DENSE);
        RuBiomeDefaultFeatures.addWaratah(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ELEPHANT_EAR_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.EUCALYPTUS_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = WetBiomes.baseJungleSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(1.3f).m_47611_(0.85f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome fen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(WetBiomes.calculateSkyColor(0.4f)).m_48019_(12638463).m_48034_(-11629645).m_48037_(-12884349).m_48043_(8754506).m_48045_(10858333).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215730_));
        BiomeGenerationSettings.Builder biomeBuilder = WetBiomes.baseSwampGeneration(featureGetter, carverGetter, false, true);
        biomeBuilder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, RuMiscOverworldPlacements.WATER_EDGE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.DUCKWEED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.CATTAIL_FEN);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.DEAD_SCOTTS_PINE_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.DEAD_BOG_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_OAK_TREE_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.FEN_VEGETATION);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PINE_DEAD_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = WetBiomes.baseSwampSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.85f).m_47611_(0.7f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome marsh(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(WetBiomes.calculateSkyColor(0.9f)).m_48019_(12638463).m_48034_(-12092489).m_48037_(-13677218).m_48043_(-8339092).m_48045_(-8536223).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215730_));
        BiomeGenerationSettings.Builder biomeBuilder = WetBiomes.baseSwampGeneration(featureGetter, carverGetter, true, true);
        biomeBuilder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, RuMiscOverworldPlacements.MARSH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.DUCKWEED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.DEAD_BOG_TREE_RARE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.MOSS_PATCH_WITH_WATER);
        MobSpawnSettings.Builder spawnBuilder = WetBiomes.baseSwampSpawning();
        spawnBuilder.m_48376_(MobCategory.AXOLOTLS, new MobSpawnSettings.SpawnerData(EntityType.f_147039_, 5, 2, 6));
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(1.0f).m_47611_(1.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome fungalFen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(WetBiomes.calculateSkyColor(2.0f)).m_48019_(12640721).m_48034_(6338444).m_48037_(25674).m_48043_(10667597).m_48045_(8173383).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123785_, 0.01f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215730_));
        BiomeGenerationSettings.Builder biomeBuilder = WetBiomes.baseSwampGeneration(featureGetter, carverGetter, true, false);
        biomeBuilder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, RuMiscOverworldPlacements.WATER_EDGE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_PINK_BIOSHROOM);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_BROWN_MUSHROOM);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_RED_MUSHROOM);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.LUSH_PINE_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PINK_BIOSHROOM_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.FERNS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PINE_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = WetBiomes.baseSwampSpawning();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20504_, 8, 4, 8));
        spawnBuilder.m_48376_(MobCategory.AXOLOTLS, new MobSpawnSettings.SpawnerData(EntityType.f_147039_, 4, 2, 4));
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(1.15f).m_47611_(1.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome oldGrowthBayou(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(-1350062718).m_48019_(-1350062718).m_48034_(-12354486).m_48037_(-10450614).m_48043_(-9333940).m_48045_(-8609196).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.01f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215730_));
        BiomeGenerationSettings.Builder biomeBuilder = WetBiomes.baseSwampGeneration(featureGetter, carverGetter, false, true);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_CYPRESS_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_CYPRESS_TREE_DEEP);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        RuBiomeDefaultFeatures.addBayouVegetation(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ELEPHANT_EAR_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GIANT_LILY);
        MobSpawnSettings.Builder spawnBuilder = WetBiomes.baseSwampSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(1.2f).m_47611_(1.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome rainforest(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean oldGrowth) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(WetBiomes.calculateSkyColor(1.0f)).m_48019_(12638463).m_48034_(2202835).m_48037_(677798).m_48043_(-11032271).m_48045_(-9718455).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_283786_));
        BiomeGenerationSettings.Builder biomeBuilder = WetBiomes.baseJungleGeneration(featureGetter, carverGetter, oldGrowth);
        if (oldGrowth) {
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PALM_TREE_DENSE_TALL);
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.KAPOK_TREE_DENSE);
        } else {
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PALM_TREE_DENSE);
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.KAPOK_TREE_SPARSE);
        }
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIG_JUNGLE_TREE_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PALM_TREE_SHRUB);
        if (oldGrowth) {
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_WITH_FLOWERS_DENSE);
        } else {
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        }
        RuBiomeDefaultFeatures.addHibiscus(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ELEPHANT_EAR_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PALM_JUNGLE_SHRUB_MIX);
        if (oldGrowth) {
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.MOSS_PATCH_WITH_WATER_UNCOMMON);
        } else {
            biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.MOSS_PATCH_WITH_WATER_RARE);
        }
        MobSpawnSettings.Builder spawnBuilder = WetBiomes.baseJungleSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.95f).m_47611_(0.9f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }
}

