/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class AshenTreeFeature
extends Feature<RuTreeConfiguration> {
    public AshenTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int height_main = context.m_225041_().m_188503_(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        int min_leaves = randomSource.m_188503_(2) + 3;
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            if (placeCheck >= min_leaves) {
                this.placeRandomChanceLeaves((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration);
                this.placeRandomChanceLeaves((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration);
                this.placeRandomChanceLeaves((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration);
                this.placeRandomChanceLeaves((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration);
            }
            if (placeCheck == height_main) {
                this.placeLeavesTop((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                this.placeBranches((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, height_main, min_leaves);
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public boolean placeLogX(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (AshenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, (BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeLogZ(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (AshenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, (BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (AshenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, treeConfiguration.trunkProvider.m_213972_(randomSource, pos), 2);
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeBranches(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, int height_main, int min_leaves) {
        int n = randomSource.m_188503_(height_main - min_leaves);
        int s = randomSource.m_188503_(height_main - min_leaves);
        int e = randomSource.m_188503_(height_main - min_leaves);
        int w = randomSource.m_188503_(height_main - min_leaves);
        BlockPos n_pos = new BlockPos(pos.m_123341_(), pos.m_123342_() - n, pos.m_123343_());
        BlockPos s_pos = new BlockPos(pos.m_123341_(), pos.m_123342_() - s, pos.m_123343_());
        BlockPos e_pos = new BlockPos(pos.m_123341_(), pos.m_123342_() - e, pos.m_123343_());
        BlockPos w_pos = new BlockPos(pos.m_123341_(), pos.m_123342_() - w, pos.m_123343_());
        this.placeLogZ(level, n_pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, n_pos.m_122012_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, n_pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, n_pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLogZ(level, s_pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, s_pos.m_122019_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, s_pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, s_pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLogX(level, e_pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, e_pos.m_122029_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, e_pos.m_122029_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, e_pos.m_122029_().m_122019_(), randomSource, treeConfiguration);
        this.placeLogX(level, w_pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, w_pos.m_122024_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, w_pos.m_122024_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, w_pos.m_122024_().m_122019_(), randomSource, treeConfiguration);
        return true;
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 2;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            if (level.m_8055_((BlockPos)placePos).m_247087_() && level.m_8055_(placePos.m_7494_()).m_204336_(BlockTags.f_144274_)) {
                level.m_7731_((BlockPos)placePos, Blocks.f_152548_.m_49966_(), 2);
                break;
            }
            if (!level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_144274_) && !level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_278411_) && !level.m_46859_((BlockPos)placePos)) break;
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public boolean placeRandomChanceLeaves(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (random.nextInt(3) == 0) {
            this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLeavesTop(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return AshenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, AshenTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, AshenTreeFeature::isReplaceableBlock);
    }
}

