/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class SmallOakTreeFeature
extends Feature<RuTreeConfiguration> {
    public SmallOakTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int height_main = context.m_225041_().m_188503_(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            if (placeCheck == height_main) {
                this.placeTop((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public void placeTop(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos placePosn = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() - (randomSource.m_188503_(2) + 1), pos.m_123343_());
        BlockPos.MutableBlockPos placePoss = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() - (randomSource.m_188503_(2) + 1), pos.m_123343_());
        BlockPos.MutableBlockPos placePose = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() - (randomSource.m_188503_(2) + 1), pos.m_123343_());
        BlockPos.MutableBlockPos placePosw = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() - (randomSource.m_188503_(2) + 1), pos.m_123343_());
        this.placeNorthBranch(level, (BlockPos)placePosn, randomSource, treeConfiguration);
        this.placeSouthBranch(level, (BlockPos)placePoss, randomSource, treeConfiguration);
        this.placeEastBranch(level, (BlockPos)placePose, randomSource, treeConfiguration);
        this.placeWestBranch(level, (BlockPos)placePosw, randomSource, treeConfiguration);
        this.placeLeavesBlob(level, pos, randomSource, treeConfiguration);
    }

    public void placeLeavesBlob(LevelAccessor level, BlockPos pos1, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos pos = pos1.m_122032_();
        Random random = new Random();
        this.placeLeavesBlock(level, pos.m_6630_(3), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_6630_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, (BlockPos)pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122019_().m_122024_(), randomSource, treeConfiguration);
    }

    public void placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, Direction.Axis axis) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return;
        }
        if (SmallOakTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, (BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 2);
        }
    }

    public void placeBranchDecorator(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (randomSource.m_188503_(10) == 0) {
            int rd = random.nextInt(4);
            if (rd == 0) {
                this.placeNorthBranch(level, pos, randomSource, treeConfiguration);
            } else if (rd == 1) {
                this.placeSouthBranch(level, pos, randomSource, treeConfiguration);
            } else if (rd == 2) {
                this.placeEastBranch(level, pos, randomSource, treeConfiguration);
            } else {
                this.placeWestBranch(level, pos, randomSource, treeConfiguration);
            }
        }
    }

    public void placeNorthBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122012_()).m_247087_() && !level.m_151570_(pos.m_122012_())) {
            level.m_7731_(pos.m_122012_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.NORTH), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_7494_())) {
            level.m_7731_(pos.m_122012_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_7495_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_7495_())) {
            level.m_7731_(pos.m_122012_().m_7495_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122012_())) {
            level.m_7731_(pos.m_122012_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122029_())) {
            level.m_7731_(pos.m_122012_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122024_())) {
            level.m_7731_(pos.m_122012_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeSouthBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122019_()).m_247087_() && !level.m_151570_(pos.m_122019_())) {
            level.m_7731_(pos.m_122019_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_7494_())) {
            level.m_7731_(pos.m_122019_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_7495_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_7495_())) {
            level.m_7731_(pos.m_122019_().m_7495_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122019_())) {
            level.m_7731_(pos.m_122019_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122029_())) {
            level.m_7731_(pos.m_122019_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122024_())) {
            level.m_7731_(pos.m_122019_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeEastBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122029_()).m_247087_() && !level.m_151570_(pos.m_122029_())) {
            level.m_7731_(pos.m_122029_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.EAST), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_7494_())) {
            level.m_7731_(pos.m_122029_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_7495_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_7495_())) {
            level.m_7731_(pos.m_122029_().m_7495_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122029_())) {
            level.m_7731_(pos.m_122029_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122019_())) {
            level.m_7731_(pos.m_122029_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122012_())) {
            level.m_7731_(pos.m_122029_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeWestBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122024_()).m_247087_() && !level.m_151570_(pos.m_122024_())) {
            level.m_7731_(pos.m_122024_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.WEST), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_7494_())) {
            level.m_7731_(pos.m_122024_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_7495_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_7495_())) {
            level.m_7731_(pos.m_122024_().m_7495_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122024_())) {
            level.m_7731_(pos.m_122024_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122019_())) {
            level.m_7731_(pos.m_122024_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122012_())) {
            level.m_7731_(pos.m_122024_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return SmallOakTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, SmallOakTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, SmallOakTreeFeature::isReplaceableBlock);
    }
}

