/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;

public final class TimedEndimation {
    private int duration;
    private int tick;
    private boolean decrementing;
    private boolean paused;

    public TimedEndimation(int duration, int startingValue) {
        this.duration = duration;
        this.tick = startingValue;
    }

    public void tick() {
        if (this.paused) {
            return;
        }
        boolean decrementing = this.decrementing;
        int tick = this.tick--;
        if (!(decrementing && tick > 0 || decrementing || tick >= this.duration)) {
            ++this.tick;
        }
    }

    public boolean isDecrementing() {
        return this.decrementing;
    }

    public void setDecrementing(boolean decrementing) {
        this.decrementing = decrementing;
    }

    public boolean isMaxed() {
        return this.tick >= this.duration;
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public void addTick(int amount) {
        this.tick += amount;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void reset() {
        this.tick = 0;
        this.paused = false;
        this.decrementing = false;
    }

    public float getProgress(float partialTicks) {
        float tick = this.tick;
        if (!this.paused) {
            tick = this.decrementing ? (float)this.tick - partialTicks : (float)this.tick + partialTicks;
        }
        return Mth.m_14036_((float)(tick / (float)this.duration), (float)0.0f, (float)1.0f);
    }

    public float getProgress(Function<Float, Float> easing, float partialTicks) {
        return easing.apply(Float.valueOf(this.getProgress(partialTicks))).floatValue();
    }

    public float getServerProgress() {
        return this.getProgress(0.0f);
    }

    public float getServerProgress(Function<Float, Float> easing) {
        return easing.apply(Float.valueOf(this.getServerProgress())).floatValue();
    }

    public CompoundTag write(CompoundTag tag) {
        tag.m_128405_("Tick", this.tick);
        tag.m_128379_("Decrementing", this.decrementing);
        tag.m_128379_("Paused", this.paused);
        return tag;
    }

    public void read(CompoundTag tag) {
        this.tick = tag.m_128451_("Tick");
        this.decrementing = tag.m_128471_("Decrementing");
        this.paused = tag.m_128471_("Paused");
    }
}

