/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.plugin;

import com.github.exopandora.shouldersurfing.ShoulderSurfingCommon;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingPlugin;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingRegistrar;
import com.github.exopandora.shouldersurfing.compat.Mods;
import com.github.exopandora.shouldersurfing.compat.plugin.CreateModTargetCameraOffsetCallback;
import com.github.exopandora.shouldersurfing.config.Config;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ShoulderSurfingPlugin
implements IShoulderSurfingPlugin {
    @Override
    public void register(IShoulderSurfingRegistrar registrar) {
        registrar.registerAdaptiveItemCallback(ShoulderSurfingPlugin::isHoldingAdaptiveItem);
        if (Mods.CREATE.isLoaded()) {
            try {
                ShoulderSurfingCommon.LOGGER.info("Registering compatibility callback for create mod");
                registrar.registerTargetCameraOffsetCallback(new CreateModTargetCameraOffsetCallback());
            }
            catch (Throwable t) {
                ShoulderSurfingCommon.LOGGER.error("Failed to load compatibility callback for create mod", t);
            }
        }
    }

    private static boolean isHoldingAdaptiveItem(Minecraft minecraft, LivingEntity entity) {
        Item useItem = entity.m_21211_().m_41720_();
        List<? extends String> useItems = Config.CLIENT.getAdaptiveCrosshairUseItems();
        List<? extends String> useItemProperties = Config.CLIENT.getAdaptiveCrosshairUseItemProperties();
        String useItemId = BuiltInRegistries.f_257033_.m_7981_((Object)useItem).toString();
        if (useItems.stream().map(ShoulderSurfingPlugin::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(useItemId))) {
            return true;
        }
        for (String string : useItemProperties) {
            if (ItemProperties.m_117829_((Item)useItem, (ResourceLocation)new ResourceLocation(string)) == null) continue;
            return true;
        }
        List<? extends String> holdItems = Config.CLIENT.getAdaptiveCrosshairHoldItems();
        List<? extends String> list = Config.CLIENT.getAdaptiveCrosshairHoldItemProperties();
        for (ItemStack handStack : entity.m_6167_()) {
            Item handItem = handStack.m_41720_();
            String handItemId = BuiltInRegistries.f_257033_.m_7981_((Object)handItem).toString();
            if (holdItems.stream().map(ShoulderSurfingPlugin::expressionToMatchPredicate).anyMatch(pattern -> pattern.test(handItemId))) {
                return true;
            }
            for (String string : list) {
                if (ItemProperties.m_117829_((Item)handItem, (ResourceLocation)new ResourceLocation(string)) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static Predicate<String> expressionToMatchPredicate(String expression) {
        try {
            return Pattern.compile(expression).asMatchPredicate();
        }
        catch (Exception e) {
            return expression::equals;
        }
    }
}

