/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.core.fluid.forge.SoftFluidInternalImpl;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SoftFluidInternal {
    private static final WeakHashMap<RegistryAccess, Map<Fluid, Holder<SoftFluid>>> FLUID_MAP = new WeakHashMap();
    private static final WeakHashMap<RegistryAccess, Map<Item, Holder<SoftFluid>>> ITEM_MAP = new WeakHashMap();

    public static Holder<SoftFluid> fromVanillaFluid(Fluid fluid, RegistryAccess registryAccess) {
        if (!FLUID_MAP.containsKey(registryAccess)) {
            SoftFluidInternal.populateSlaveMaps(registryAccess);
        }
        return FLUID_MAP.get(registryAccess).get(fluid);
    }

    public static Holder<SoftFluid> fromVanillaItem(Item item, RegistryAccess registryAccess) {
        if (!ITEM_MAP.containsKey(registryAccess)) {
            SoftFluidInternal.populateSlaveMaps(registryAccess);
        }
        return ITEM_MAP.get(registryAccess).get(item);
    }

    private static void populateSlaveMaps(RegistryAccess registryAccess) {
        Map fluidMap = FLUID_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap());
        Map itemMap = ITEM_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap());
        fluidMap.clear();
        itemMap.clear();
        for (Holder.Reference<SoftFluid> h : SoftFluidRegistry.getHolders()) {
            SoftFluid s = (SoftFluid)h.m_203334_();
            if (!s.isEnabled()) continue;
            s.getEquivalentFluids().forEach(f -> fluidMap.put(f, h));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != Items.f_42589_ || !BuiltInSoftFluids.WATER.is((Holder<SoftFluid>)h)) {
                    itemMap.put(i, h);
                }
            });
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidInternalImpl.init();
    }

    public static void postInitClient() {
        FLUID_MAP.clear();
        ITEM_MAP.clear();
        SoftFluidColors.refreshParticleColors();
    }

    public static void onDataSyncToPlayer(ServerPlayer player, boolean isJoined) {
        if (isJoined) {
            ModMessages.CHANNEL.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    public static void doPostInitServer(RegistryAccess reg) {
        SoftFluidInternal.populateSlaveMaps(reg);
        SoftFluidInternal.registerExistingVanillaFluids(FLUID_MAP.get(reg), ITEM_MAP.get(reg));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(Map<Fluid, Holder<SoftFluid>> fluidMap, Map<Item, Holder<SoftFluid>> itemMap) {
        void var1_1;
        SoftFluidInternalImpl.registerExistingVanillaFluids(fluidMap, (Map<Item, Holder<SoftFluid>>)var1_1);
    }
}

