/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks;

import de.teamlapen.werewolves.util.WUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StoneAltarFireBowlBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final String REG_NAME = "stone_altar_fire_bowl";
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty SOUL_FIRE = WUtils.SOUL_FIRE;
    protected static final VoxelShape SHAPE = StoneAltarFireBowlBlock.makeShape();

    public StoneAltarFireBowlBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 14 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61450_, (Comparable)Boolean.valueOf(false)));
    }

    protected static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
        VoxelShape b = Block.m_49796_((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
        VoxelShape c = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        return Shapes.m_83124_((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c});
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult p_225533_6_) {
        ItemStack stack;
        if (!(((Boolean)state.m_61143_((Property)LIT)).booleanValue() || (stack = player.m_21120_(handIn)).m_41720_() != Items.f_42000_ && stack.m_41720_() != Items.f_42053_ || ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue())) {
            worldIn.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(stack.m_41720_() == Items.f_42053_)));
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT}).m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{SOUL_FIRE}).m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{BlockStateProperties.f_61450_});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean isBurning(BlockState state, BlockGetter world, BlockPos pos) {
        return super.isBurning(state, world, pos);
    }

    public boolean m_7361_(@Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull FluidState fluid) {
        if (super.m_7361_(world, pos, state, fluid)) {
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
                if (world.m_5776_()) {
                    for (int i = 0; i < 20; ++i) {
                        CampfireBlock.m_51251_((Level)((Level)world), (BlockPos)pos.m_6630_(1), (boolean)false, (boolean)true);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + rand.m_188500_();
            double d1 = (double)pos.m_123342_() + rand.m_188500_() + 0.7;
            double d2 = (double)pos.m_123343_() + rand.m_188500_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_());
    }
}

