/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.core;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.client.gui.ExtendedGui;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.api.items.ISilverItem;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ModHUDOverlay
extends ExtendedGui {
    private final Minecraft mc = Minecraft.m_91087_();
    private final ResourceLocation ICONS = new ResourceLocation("werewolves", "textures/gui/hud.png");
    protected static final ResourceLocation WIDGETS_TEX_PATH = new ResourceLocation("textures/gui/widgets.png");
    private int screenColor = 0;
    private int screenPercentage = 0;
    private final List<Integer> entities = new ArrayList<Integer>();
    private int attackTargetScreenPercentage = 0;
    private int waitTicks = 0;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.f_91074_ == null || !this.mc.f_91074_.m_6084_()) {
            this.screenPercentage = 0;
            this.attackTargetScreenPercentage = 0;
            this.entities.clear();
            this.waitTicks = 0;
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        FactionPlayerHandler.getCurrentFactionPlayer((Player)this.mc.f_91074_).filter(WerewolfPlayer.class::isInstance).ifPresentOrElse(player -> this.handleScreenColorWerewolf((WerewolfPlayer)player), () -> {
            this.screenPercentage = 0;
            this.attackTargetScreenPercentage = 0;
            this.waitTicks = 0;
            this.entities.clear();
        });
    }

    @SubscribeEvent
    public void onRenderGui(RenderGuiOverlayEvent.Pre event) {
        if (this.mc.f_91074_ == null || !this.mc.f_91074_.m_6084_() || event.getOverlay() != VanillaGuiOverlay.CROSSHAIR.type()) {
            return;
        }
        this.renderCrosshair(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderWorldLast(RenderGuiEvent.Pre event) {
        int percentages = 0;
        int color = 0;
        if (this.screenPercentage > 0) {
            percentages = this.screenPercentage;
            color = this.screenColor;
        } else if (this.attackTargetScreenPercentage > 0) {
            percentages = this.attackTargetScreenPercentage;
            color = -37369;
        }
        if (percentages > 0 && ((Boolean)VampirismConfig.CLIENT.renderScreenOverlay.get()).booleanValue()) {
            PoseStack stack = event.getGuiGraphics().m_280168_();
            stack.m_85836_();
            int w = this.mc.m_91268_().m_85445_();
            int h = this.mc.m_91268_().m_85446_();
            int bh = Math.round((float)h / 4.0f * (float)percentages / 100.0f);
            int bw = Math.round((float)w / 8.0f * (float)percentages / 100.0f);
            event.getGuiGraphics().m_280024_(0, 0, w, bh, color, 0);
            if (!OptifineHandler.isShaders()) {
                event.getGuiGraphics().m_280024_(0, h - bh, w, h, 0, color);
            }
            this.fillGradient2(stack, 0, 0, bw, h, 0, color);
            this.fillGradient2(stack, w - bw, 0, w, h, color, 0);
            stack.m_85849_();
        }
    }

    public void attackTriggered(int entityId) {
        if (!this.entities.contains(entityId)) {
            this.entities.add(entityId);
            if (this.waitTicks == 0) {
                this.screenPercentage = 100;
                this.waitTicks = 100;
                this.screenColor = -37369;
            }
        }
    }

    private void handleScreenColorWerewolf(WerewolfPlayer player) {
        boolean sixth_sense = player.getSkillHandler().isSkillEnabled((ISkill)ModSkills.SIXTH_SENSE.get());
        boolean rage = player.getActionHandler().isActionActive((ILastingAction)ModActions.RAGE.get());
        if (sixth_sense) {
            if (this.screenPercentage > 0) {
                this.screenPercentage -= 10;
            }
            if (this.waitTicks > 0) {
                --this.waitTicks;
            }
        } else {
            this.waitTicks = 0;
            this.entities.clear();
        }
        if (rage) {
            this.screenPercentage = 100;
            this.screenColor = -1048576;
        }
        if (!sixth_sense && !rage) {
            this.screenPercentage = 0;
        }
    }

    private void renderFangs(GuiGraphics graphics, int width, int height, @Nullable Entity entity) {
        int left = width / 2 - 9;
        int top = height / 2 - 6;
        boolean silver = false;
        if (entity != null) {
            for (ItemStack stack : entity.m_6168_()) {
                if (!(stack.m_41720_() instanceof ISilverItem)) continue;
                silver = true;
                break;
            }
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280163_(this.ICONS, left, top, silver ? 30.0f : 15.0f, 0.0f, 15, 15, 256, 256);
    }

    private void renderCrosshair(RenderGuiOverlayEvent.Pre event) {
        if (((Boolean)WerewolvesConfig.CLIENT.disableFangCrosshairRendering.get()).booleanValue()) {
            return;
        }
        if (Helper.isWerewolf((Player)this.mc.f_91074_)) {
            LivingEntity entity;
            LivingEntity living;
            EntityHitResult entityResult;
            Entity entity2;
            HitResult result = Minecraft.m_91087_().f_91077_;
            LivingEntity livingEntity = result instanceof EntityHitResult ? ((entity2 = (entityResult = (EntityHitResult)result).m_82443_()) instanceof LivingEntity ? (living = (LivingEntity)entity2) : null) : (entity = null);
            if (entity != null && WerewolfPlayer.get((Player)this.mc.f_91074_).canBite()) {
                this.renderFangs(event.getGuiGraphics(), this.mc.m_91268_().m_85445_(), this.mc.m_91268_().m_85446_(), (Entity)entity);
                event.setCanceled(true);
            }
        }
    }
}

