/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.core;

import com.mojang.blaze3d.pipeline.RenderTarget;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RenderHandler
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ENTITY_NEAR_SQ_DISTANCE = 100;
    @Nonnull
    private final Minecraft mc;
    private final int VISION_FADE_TICKS = 30;
    private OutlineBufferSource visionBuffer;
    private int ticks;
    private int lastTicks;
    @Nullable
    private PostChain blurShader;
    private int displayHeight;
    private int displayWidth;
    private boolean isInsideVisionRendering = false;
    private PostPass blit;
    private PostPass blur1;
    private PostPass blur2;

    public RenderHandler(@Nonnull Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onCameraSetup(@NotNull ViewportEvent.ComputeCameraAngles event) {
        if (this.shouldRenderVision()) {
            this.updateDisplaySize();
            this.adjustVisionShaders(this.getVisionProgress((float)event.getPartialTick()));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.f_91073_ == null || this.mc.f_91074_ == null || !this.mc.f_91074_.m_6084_()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.lastTicks = this.ticks;
        LazyOptional<WerewolfPlayer> werewolf = WerewolfPlayer.getOpt((Player)this.mc.f_91074_);
        if (werewolf.filter(s -> s.getActionHandler().isActionActive((ILastingAction)ModActions.SENSE.get())).isPresent()) {
            if (this.ticks < 30) {
                ++this.ticks;
            }
        } else if (this.ticks > 0) {
            this.ticks -= 2;
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(@NotNull RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity;
        double dist;
        if (!this.isInsideVisionRendering && this.shouldRenderVision() && !((dist = this.mc.f_91074_.m_20280_((Entity)(entity = event.getEntity()))) > (double)((Integer)VampirismConfig.BALANCE.vsBloodVisionDistanceSq.get()).intValue()) && !entity.m_20069_()) {
            int color = 0xA0A0A0;
            if (entity instanceof IFactionEntity) {
                color = ((IFactionEntity)entity).getFaction().getColor();
            } else if (!entity.m_21222_()) {
                color = 0xFF0000;
            }
            EntityRenderDispatcher renderManager = this.mc.m_91290_();
            if (this.visionBuffer == null) {
                this.visionBuffer = new OutlineBufferSource(this.mc.m_91269_().m_110104_());
            }
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int alpha = (int)((dist > 100.0 ? 50.0 : dist / 100.0 * 50.0) * (double)this.getVisionProgress(event.getPartialTick()));
            this.visionBuffer.m_109929_(r, g, b, alpha);
            float f = Mth.m_14179_((float)event.getPartialTick(), (float)entity.f_19859_, (float)entity.m_146908_());
            this.isInsideVisionRendering = true;
            EntityRenderer entityRenderer = renderManager.m_114382_((Entity)entity);
            entityRenderer.m_7392_((Entity)entity, f, event.getPartialTick(), event.getPoseStack(), (MultiBufferSource)this.visionBuffer, renderManager.m_114394_((Entity)entity, event.getPartialTick()));
            this.mc.m_91385_().m_83947_(false);
            this.isInsideVisionRendering = false;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        this.ticks = 0;
    }

    private float getVisionProgress(float partialTicks) {
        return ((float)this.ticks + (float)(this.ticks - this.lastTicks) * partialTicks) / 30.0f;
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            if (this.mc.f_91073_ == null) {
                return;
            }
            if (this.shouldRenderVision()) {
                this.blurShader.m_110023_(event.getPartialTick());
                this.mc.m_91385_().m_83947_(false);
            }
        }
    }

    public void endVisionBatch() {
        if (this.shouldRenderVision() && this.visionBuffer != null) {
            this.visionBuffer.m_109928_();
        }
    }

    private void updateDisplaySize() {
        if (this.displayHeight != this.mc.m_91268_().m_85442_() || this.displayWidth != this.mc.m_91268_().m_85441_()) {
            this.displayHeight = this.mc.m_91268_().m_85442_();
            this.displayWidth = this.mc.m_91268_().m_85441_();
            this.updateFramebufferSize(this.displayWidth, this.displayHeight);
        }
    }

    private void adjustVisionShaders(float progress) {
        if (this.blit == null || this.blur1 == null) {
            return;
        }
        progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        this.blit.m_110074_().m_108960_("ColorModulate").m_5805_(1.0f - 0.4f * progress, 1.0f - 0.5f * progress, 1.0f - 0.3f * progress, 1.0f);
        this.blur1.m_110074_().m_108960_("Radius").m_5985_((float)Math.round(5.0f * progress));
        this.blur2.m_110074_().m_108960_("Radius").m_5985_((float)Math.round(5.0f * progress));
    }

    private void updateFramebufferSize(int width, int height) {
        if (this.blurShader != null) {
            this.blurShader.m_110025_(width, height);
        }
    }

    private boolean shouldRenderVision() {
        return this.ticks > 0 && this.blurShader != null && this.mc.f_91074_ != null;
    }

    public void m_6213_(@Nonnull ResourceManager p_10758_) {
        this.reMakeShader();
    }

    private void reMakeShader() {
        if (this.blurShader != null) {
            this.blurShader.close();
        }
        ResourceLocation resourcelocationBlur = new ResourceLocation("vampirism", "shaders/blank.json");
        try {
            this.blurShader = new PostChain(this.mc.m_91097_(), this.mc.m_91098_(), this.mc.m_91385_(), resourcelocationBlur);
            RenderTarget swap = this.blurShader.m_110036_("swap");
            this.blit = this.blurShader.m_110042_("blit", swap, this.mc.m_91385_());
            this.blur1 = this.blurShader.m_110042_("blur", this.mc.m_91385_(), swap);
            this.blur1.m_110074_().m_108960_("BlurDir").m_7971_(1.0f, 0.0f);
            this.blur2 = this.blurShader.m_110042_("blur", swap, this.mc.m_91385_());
            this.blur2.m_110074_().m_108960_("BlurDir").m_7971_(0.0f, 1.0f);
            this.blurShader.m_110025_(this.mc.m_91268_().m_85441_(), this.mc.m_91268_().m_85442_());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load blood vision blur shader", (Throwable)e);
            this.blurShader = null;
        }
    }
}

