/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import de.teamlapen.vampirism.data.ModBlockFamilies;
import de.teamlapen.werewolves.core.ModRegistries;
import de.teamlapen.werewolves.data.BlockStateGenerator;
import de.teamlapen.werewolves.data.GlobalLootTableGenerator;
import de.teamlapen.werewolves.data.ItemModelGenerator;
import de.teamlapen.werewolves.data.LootTablesGenerator;
import de.teamlapen.werewolves.data.ModTagsProvider;
import de.teamlapen.werewolves.data.RecipeGenerator;
import de.teamlapen.werewolves.data.SkillNodeGenerator;
import de.teamlapen.werewolves.mixin.RegistriesDatapackGeneratorAccessor;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DataPackRegistriesHooks;

@Mod.EventBusSubscriber(modid="werewolves", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = event.getLookupProvider();
        ModBlockFamilies.init();
        DatapackBuiltinEntriesProvider provider = new DatapackBuiltinEntriesProvider(packOutput, DataGeneration.extendedProvider(lookupProvider, ModRegistries.DATA_BUILDER), Set.of("werewolves"));
        generator.addProvider(event.includeServer(), (DataProvider)provider);
        lookupProvider = ((RegistriesDatapackGeneratorAccessor)provider).getRegistries();
        ModTagsProvider.register(generator, event, packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTablesGenerator(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new GlobalLootTableGenerator(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new SkillNodeGenerator(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(packOutput, existingFileHelper));
    }

    private static CompletableFuture<HolderLookup.Provider> addVampirismRegistries(CompletableFuture<HolderLookup.Provider> lookupProvider, PackOutput packOutput) {
        DatapackBuiltinEntriesProvider vampirism = new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, de.teamlapen.vampirism.core.ModRegistries.DATA_BUILDER, Set.of("vampirism"));
        return ((RegistriesDatapackGeneratorAccessor)vampirism).getRegistries();
    }

    private static CompletableFuture<HolderLookup.Provider> extendedProvider(CompletableFuture<HolderLookup.Provider> future, RegistrySetBuilder ... builder) {
        return future.thenApply(provider -> {
            for (RegistrySetBuilder datapackEntriesBuilder : builder) {
                HashSet builderKeys = new HashSet(datapackEntriesBuilder.getEntryKeys());
                DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().filter(data -> !builderKeys.contains(data.f_243794_())).forEach(data -> datapackEntriesBuilder.m_254916_(data.f_243794_(), context -> {}));
            }
            RegistryAccess.Frozen frozen = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
            for (RegistrySetBuilder registrySetBuilder : builder) {
                provider = registrySetBuilder.m_254929_((RegistryAccess)frozen, provider);
            }
            return provider;
        });
    }
}

