/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.modcompat.playeranimator;

import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;

public class PlayerAnimatorCompat {
    private static boolean modChecked = false;
    private static boolean skipCheck;
    private static Method isFirstPersonPassMethod;
    private static Class<?> iAnimatedPlayerClass;
    private static Method getAnimationApplierMethod;

    public static boolean checkAnimation(Player player) {
        if (!PlayerAnimatorCompat.checkMod()) {
            return false;
        }
        if (Minecraft.m_91087_().f_91074_ != player) {
            return false;
        }
        return PlayerAnimatorCompat.checkFirstPersonAnimation(player);
    }

    private static boolean checkMod() {
        if (!modChecked) {
            skipCheck = !ModList.get().isLoaded("playeranimator");
            modChecked = false;
        }
        return !skipCheck;
    }

    private static boolean checkFirstPersonAnimation(Player player) {
        try {
            if (!PlayerAnimatorCompat.isFirstPersonPass()) {
                return false;
            }
            return PlayerAnimatorCompat.isAnimationActive(player);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isFirstPersonPass() throws ReflectiveOperationException {
        Object isFirstPersonPass;
        if (isFirstPersonPassMethod == null) {
            isFirstPersonPassMethod = Class.forName("dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode").getMethod("isFirstPersonPass", new Class[0]);
        }
        return (isFirstPersonPass = isFirstPersonPassMethod.invoke(null, new Object[0])) != null && (Boolean)isFirstPersonPass != false;
    }

    private static boolean isAnimationActive(Player player) throws ReflectiveOperationException {
        if (iAnimatedPlayerClass == null || getAnimationApplierMethod == null) {
            iAnimatedPlayerClass = Class.forName("dev.kosmx.playerAnim.impl.IAnimatedPlayer");
            getAnimationApplierMethod = iAnimatedPlayerClass.getMethod("playerAnimator_getAnimation", new Class[0]);
        }
        if (!iAnimatedPlayerClass.isInstance(player)) {
            return false;
        }
        Object animationApplier = getAnimationApplierMethod.invoke((Object)player, new Object[0]);
        return (Boolean)animationApplier.getClass().getMethod("isActive", new Class[0]).invoke(animationApplier, new Object[0]);
    }
}

