/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.client.model;

import com.enderio.base.client.renderer.PaintedBlockColor;
import com.enderio.base.common.blockentity.DoublePaintedBlockEntity;
import com.enderio.base.common.blockentity.IPaintableBlockEntity;
import com.enderio.base.common.blockentity.SinglePaintedBlockEntity;
import com.enderio.base.common.util.PaintUtils;
import com.enderio.core.client.RenderUtil;
import com.enderio.core.data.model.EIOModel;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class PaintedBlockModel
implements IDynamicBakedModel {
    private final Map<Block, List<BakedModel>> itemRenderCache = new HashMap<Block, List<BakedModel>>();
    private final Block reference;
    @Nullable
    private final Direction rotateItemTo;

    public PaintedBlockModel(Block reference, @Nullable Direction rotateItemTo) {
        this.reference = reference;
        this.rotateItemTo = rotateItemTo;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        if (state != null) {
            BlockState replicaState = this.replicateState(state);
            if (state.m_61138_((Property)SlabBlock.f_56353_)) {
                List shape;
                Block paint;
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                SlabType slabType = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
                if (slabType == SlabType.BOTTOM || slabType == SlabType.DOUBLE) {
                    paint = (Block)extraData.get(DoublePaintedBlockEntity.PAINT);
                    shape = this.getModel((BlockState)replicaState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM)).getQuads(state, side, rand, ModelData.EMPTY, renderType);
                    IQuadTransformer transformer = quad -> {
                        quad.f_111293_ = PaintedBlockColor.moveTintIndex(quad.m_111305_());
                    };
                    quads.addAll(transformer.process(this.getQuadsUsingShape(paint, shape, side, rand, null, renderType)));
                }
                if (slabType == SlabType.TOP || slabType == SlabType.DOUBLE) {
                    paint = (Block)extraData.get(DoublePaintedBlockEntity.PAINT2);
                    shape = this.getModel((BlockState)replicaState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP)).getQuads(state, side, rand, ModelData.EMPTY, renderType);
                    quads.addAll(this.getQuadsUsingShape(paint, shape, side, rand, null, renderType));
                }
                return quads;
            }
            List shape = this.getModel(replicaState).m_213637_(replicaState, side, rand);
            Direction direction = null;
            for (Property property : state.m_61147_()) {
                if (!(property instanceof DirectionProperty)) continue;
                DirectionProperty directionProperty = (DirectionProperty)property;
                direction = ((Direction)state.m_61143_((Property)directionProperty)).m_122424_();
            }
            return this.getQuadsUsingShape((Block)extraData.get(SinglePaintedBlockEntity.PAINT), shape, side, rand, direction, renderType);
        }
        return List.of();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        BakedModel model;
        TextureAtlasSprite sprite;
        Block paint = (Block)data.get(SinglePaintedBlockEntity.PAINT);
        if (paint != null && !(sprite = (model = this.getModel(paint.m_49966_())).getParticleIcon(ModelData.EMPTY)).m_245424_().m_246162_().m_135815_().equals("missingno")) {
            return sprite;
        }
        if (data.has(DoublePaintedBlockEntity.PAINT2) && (paint = (Block)data.get(DoublePaintedBlockEntity.PAINT2)) != null) {
            model = this.getModel(paint.m_49966_());
            return model.getParticleIcon(ModelData.EMPTY);
        }
        return EIOModel.getMissingTexture();
    }

    public TextureAtlasSprite m_6160_() {
        return EIOModel.getMissingTexture();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState paintedBlockState, RandomSource rand, ModelData data) {
        ChunkRenderTypeSet chunkRenderTypeSet = ChunkRenderTypeSet.union(IPaintableBlockEntity.PAINT_DATA_PROPERTIES.stream().map(arg_0 -> ((ModelData)data).get(arg_0)).filter(Objects::nonNull).map(Block::m_49966_).map(state -> this.getModel((BlockState)state).getRenderTypes(state, rand, ModelData.EMPTY)).toList());
        if (chunkRenderTypeSet.isEmpty()) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110451_()});
        }
        return chunkRenderTypeSet;
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        @Nullable Block paint = PaintUtils.getPaint(itemStack);
        if (paint != null) {
            return List.of(ItemBlockRenderTypes.m_109284_((BlockState)paint.m_49966_(), (boolean)fabulous));
        }
        return List.of(fabulous ? Sheets.m_110792_() : Sheets.m_110791_());
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        Block paint = PaintUtils.getPaint(itemStack);
        if (paint != null) {
            return this.itemRenderCache.computeIfAbsent(paint, paintKey -> List.of(new ItemModel(paint)));
        }
        return List.of(this);
    }

    public ItemTransforms m_7442_() {
        return this.getItemModel().m_7442_();
    }

    private BakedModel getModel(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }

    private BakedModel getItemModel() {
        return Minecraft.m_91087_().m_91291_().m_174264_(this.reference.m_5456_().m_7968_(), null, null, 0);
    }

    private BlockState replicateState(@Nullable BlockState selfState) {
        BlockState toState = this.reference.m_49966_();
        if (selfState == null) {
            return toState;
        }
        for (Property property : selfState.m_61147_()) {
            EnumProperty enumProperty;
            BooleanProperty booleanProperty;
            if (property instanceof BooleanProperty && toState.m_61138_((Property)(booleanProperty = (BooleanProperty)property))) {
                toState = (BlockState)toState.m_61124_((Property)booleanProperty, (Comparable)((Boolean)selfState.m_61143_((Property)booleanProperty)));
            }
            if (!(property instanceof EnumProperty) || !toState.m_61138_((Property)(enumProperty = (EnumProperty)property))) continue;
            toState = (BlockState)toState.m_61124_((Property)enumProperty, selfState.m_61143_((Property)enumProperty));
        }
        return toState;
    }

    protected List<BakedQuad> getQuadsUsingShape(@Nullable Block paint, List<BakedQuad> shape, @Nullable Direction side, RandomSource rand, @Nullable Direction rotation, @Nullable RenderType renderType) {
        if (paint != null) {
            BakedModel model = this.getModel(this.paintWithRotation(paint, rotation));
            Optional<Pair<TextureAtlasSprite, Boolean>> spriteOptional = this.getSpriteData(paint, side, rand, rotation, renderType);
            ArrayList<BakedQuad> returnQuads = new ArrayList<BakedQuad>();
            for (BakedQuad shapeQuad : shape) {
                Pair spriteData = spriteOptional.orElseGet(() -> this.getSpriteFromModel(shapeQuad, model, paint, rotation));
                returnQuads.add(this.paintQuad(shapeQuad, (TextureAtlasSprite)spriteData.getFirst(), (Boolean)spriteData.getSecond()));
            }
            return returnQuads;
        }
        return List.of();
    }

    private BlockState paintWithRotation(Block paint, @Nullable Direction rotation) {
        BlockState state = paint.m_49966_();
        if (rotation != null) {
            for (Property property : state.m_61147_()) {
                DirectionProperty directionProperty;
                if (!(property instanceof DirectionProperty) || !(directionProperty = (DirectionProperty)property).m_6908_().contains(rotation)) continue;
                state = (BlockState)state.m_61124_((Property)directionProperty, (Comparable)rotation);
            }
        }
        return state;
    }

    private Optional<Pair<TextureAtlasSprite, Boolean>> getSpriteData(Block paint, @Nullable Direction side, RandomSource rand, @Nullable Direction rotation, @Nullable RenderType renderType) {
        BlockState state = this.paintWithRotation(paint, rotation);
        List quads = this.getModel(state).getQuads(state, side, rand, ModelData.EMPTY, renderType);
        return quads.isEmpty() ? Optional.empty() : Optional.of(Pair.of((Object)((BakedQuad)quads.get(0)).m_173410_(), (Object)((BakedQuad)quads.get(0)).m_111304_()));
    }

    protected Pair<TextureAtlasSprite, Boolean> getSpriteFromModel(BakedQuad shape, BakedModel model, Block paint, Direction rotation) {
        BlockState state = this.paintWithRotation(paint, rotation);
        List quads = model.m_213637_(state, shape.m_111306_(), RandomSource.m_216327_());
        return quads.isEmpty() ? Pair.of((Object)EIOModel.getMissingTexture(), (Object)false) : Pair.of((Object)((BakedQuad)quads.get(0)).m_173410_(), (Object)((BakedQuad)quads.get(0)).m_111304_());
    }

    protected BakedQuad paintQuad(BakedQuad toCopy, TextureAtlasSprite sprite, boolean shouldTint) {
        BakedQuad copied = new BakedQuad(Arrays.copyOf(toCopy.m_111303_(), 32), shouldTint ? 1 : -1, toCopy.m_111306_(), sprite, toCopy.m_111307_());
        for (int i = 0; i < 4; ++i) {
            float[] uv0 = RenderUtil.unpackVertices(copied.m_111303_(), i, IQuadTransformer.UV0, 2);
            uv0[0] = (uv0[0] - toCopy.m_173410_().m_118409_()) * (float)sprite.m_245424_().m_246492_() / (float)toCopy.m_173410_().m_245424_().m_246492_() + sprite.m_118409_();
            uv0[1] = (uv0[1] - toCopy.m_173410_().m_118411_()) * (float)sprite.m_245424_().m_245330_() / (float)toCopy.m_173410_().m_245424_().m_245330_() + sprite.m_118411_();
            int[] packedTextureData = RenderUtil.packUV(uv0[0], uv0[1]);
            copied.m_111303_()[IQuadTransformer.UV0 + i * IQuadTransformer.STRIDE] = packedTextureData[0];
            copied.m_111303_()[IQuadTransformer.UV0 + 1 + i * IQuadTransformer.STRIDE] = packedTextureData[1];
        }
        return copied;
    }

    private class ItemModel
    implements IDynamicBakedModel {
        private final Block paint;
        private final Map<Direction, List<BakedQuad>> bakedQuads = new HashMap<Direction, List<BakedQuad>>();

        private ItemModel(Block paint) {
            this.paint = paint;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
            return this.bakedQuads.computeIfAbsent(side, side1 -> PaintedBlockModel.this.getQuadsUsingShape(this.paint, PaintedBlockModel.this.getItemModel().getQuads(state, side, rand, ModelData.EMPTY, renderType), (Direction)side1, rand, PaintedBlockModel.this.rotateItemTo, renderType));
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return PaintedBlockModel.this.m_6160_();
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }

        public ItemTransforms m_7442_() {
            return PaintedBlockModel.this.getItemModel().m_7442_();
        }
    }
}

