/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.loot;

import com.enderio.base.common.capacitor.CapacitorUtil;
import com.enderio.base.common.capacitor.LootCapacitorData;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.init.EIOLootModifiers;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SetLootCapacitorFunction
extends LootItemConditionalFunction {
    private final NumberProvider range;

    SetLootCapacitorFunction(LootItemCondition[] conditions, NumberProvider range) {
        super(conditions);
        this.range = range;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)EIOLootModifiers.SET_LOOT_CAPACITOR.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        stack.getCapability(EIOCapabilities.CAPACITOR).ifPresent(cap -> {
            if (cap instanceof LootCapacitorData) {
                LootCapacitorData lootCap = (LootCapacitorData)cap;
                lootCap.setBase(this.range.m_142688_(context));
                lootCap.addNewModifier(CapacitorUtil.getRandomModifier(context.m_230907_()), this.range.m_142688_(context));
                if (context.m_230907_().m_188501_() < 0.15f) {
                    lootCap.addModifier(CapacitorUtil.getRandomModifier(context.m_230907_()), this.range.m_142688_(context));
                }
                if (context.m_230907_().m_188501_() < 0.02f) {
                    lootCap.addModifier(CapacitorUtil.getRandomModifier(context.m_230907_()), this.range.m_142688_(context));
                }
            }
        });
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> setLootCapacitor(NumberProvider range) {
        return SetLootCapacitorFunction.m_80683_(conditions -> new SetLootCapacitorFunction((LootItemCondition[])conditions, range));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetLootCapacitorFunction> {
        public void serialize(JsonObject json, SetLootCapacitorFunction value, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)value, serializationContext);
            json.add("range", serializationContext.serialize((Object)value.range));
        }

        public SetLootCapacitorFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
            NumberProvider range = (NumberProvider)GsonHelper.m_13836_((JsonObject)object, (String)"range", (JsonDeserializationContext)deserializationContext, NumberProvider.class);
            return new SetLootCapacitorFunction(conditions, range);
        }
    }
}

