/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.energy;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class EnergyNetProbe {
    private long energyIn;
    private long energyOut;
    private final int ticks;
    private int ticksRemaining;

    public EnergyNetProbe(int ticks) {
        this.ticks = ticks;
        this.ticksRemaining = ticks;
    }

    public void addEnergyIn(long energyIn) {
        this.energyIn += energyIn;
    }

    public void addEnergyOut(long energyOut) {
        this.energyOut += energyOut;
    }

    public boolean tick() {
        return this.ticksRemaining-- <= 0;
    }

    public void finishProbe(Player player, long totalConduitEnergy, long totalConduitEnergyStorage, long machineEnergy, long machineEnergyStorage, long externalEnergy, long externalEnergyStorage) {
        StringBuilder builder = new StringBuilder();
        DecimalFormat df = new DecimalFormat();
        df.setRoundingMode(RoundingMode.HALF_EVEN);
        String netBuffers = builder.append(" - Conduit Storage: ").append(totalConduitEnergy).append(" / ").append(totalConduitEnergyStorage).append(" \u00b5I").toString();
        builder.setLength(0);
        String machineBuffers = builder.append(" - Machine Buffers: ").append(machineEnergy).append(" / ").append(machineEnergyStorage).append(" \u00b5I").toString();
        builder.setLength(0);
        String storageBanks = builder.append(" - Energy Buffers: ").append(externalEnergy).append(" / ").append(externalEnergyStorage).append(" \u00b5I").toString();
        builder.setLength(0);
        String netInput = builder.append(" - Average input over ").append(df.format((float)this.ticks / 20.0f)).append(" seconds: ").append(this.energyIn / (long)this.ticks).append(" \u00b5I/t").toString();
        builder.setLength(0);
        String netOutput = builder.append(" - Average output over ").append(df.format((float)this.ticks / 20.0f)).append(" seconds: ").append(this.energyOut / (long)this.ticks).append(" \u00b5I/t").toString();
        player.m_213846_((Component)Component.m_237113_((String)"Energy Network").m_130940_(ChatFormatting.GREEN));
        player.m_213846_((Component)Component.m_237113_((String)netBuffers).m_130940_(ChatFormatting.DARK_AQUA));
        player.m_213846_((Component)Component.m_237113_((String)storageBanks).m_130940_(ChatFormatting.DARK_AQUA));
        player.m_213846_((Component)Component.m_237113_((String)machineBuffers).m_130940_(ChatFormatting.DARK_AQUA));
        player.m_213846_((Component)Component.m_237113_((String)netInput).m_130940_(ChatFormatting.BLUE));
        player.m_213846_((Component)Component.m_237113_((String)netOutput).m_130940_(ChatFormatting.BLUE));
    }
}

