/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.network;

import de.srendi.advancedperipherals.network.base.IPacket;
import de.srendi.advancedperipherals.network.toclient.ToastToClientPacket;
import de.srendi.advancedperipherals.network.toclient.UsernameToCachePacket;
import de.srendi.advancedperipherals.network.toserver.RetrieveUsernamePacket;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class APNetworking {
    private static final String PROTOCOL_VERSION = ModLoadingContext.get().getActiveContainer().getModInfo().getVersion().toString();
    private static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("advancedperipherals", "main_channel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    private static int id = 0;

    public static void init() {
        APNetworking.registerServerToClient(ToastToClientPacket.class, ToastToClientPacket::decode);
        APNetworking.registerServerToClient(UsernameToCachePacket.class, UsernameToCachePacket::decode);
        APNetworking.registerClientToServer(RetrieveUsernamePacket.class, RetrieveUsernamePacket::decode);
    }

    public static <MSG extends IPacket> void registerServerToClient(Class<MSG> packet, Function<FriendlyByteBuf, MSG> decode) {
        NETWORK_CHANNEL.registerMessage(id++, packet, IPacket::encode, decode, IPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static <MSG extends IPacket> void registerClientToServer(Class<MSG> packet, Function<FriendlyByteBuf, MSG> decode) {
        NETWORK_CHANNEL.registerMessage(id++, packet, IPacket::encode, decode, IPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static void sendToServer(Object msg) {
        NETWORK_CHANNEL.sendToServer(msg);
    }

    public static void sendTo(Object msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), msg);
        }
    }

    public static void sendPacketToAll(Object packet) {
        NETWORK_CHANNEL.send(PacketDistributor.ALL.noArg(), packet);
    }

    public static ClientboundBlockEntityDataPacket createTEUpdatePacket(BlockEntity tile) {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)tile);
    }

    public static void sendToAllAround(Object mes, ResourceKey<Level> dim, BlockPos pos, int radius) {
        NETWORK_CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)radius, dim)), mes);
    }

    public static void sendToAllInWorld(Object mes, ServerLevel world) {
        NETWORK_CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)world).m_46472_()), mes);
    }
}

