/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.elements;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;

public class FluidItemElement
extends ItemElement {
    private final List<FluidStack> fluids;

    public FluidItemElement(int x, int y, float scale, List<ItemStack> items, List<FluidStack> fluids) {
        super(x, y, scale, items);
        if (items.size() != fluids.size()) {
            throw new IllegalArgumentException("Items and fluids must be same size");
        }
        this.fluids = fluids;
    }

    public FluidItemElement(int x, int y, float scale, List<FluidStack> fluids) {
        this(x, y, scale, FluidItemElement.createItemList(fluids), fluids);
    }

    public void drawOverlay(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Font fontRenderer) {
        if (this.isHovered(mouseX, mouseY) && this.currentItem < this.fluids.size()) {
            this.drawTooltip(graphics, FluidTooltipHandler.getFluidTooltip((FluidStack)this.fluids.get(this.currentItem)), mouseX, mouseY, fontRenderer);
        }
    }

    public static List<ItemStack> createItemList(List<FluidStack> fluids) {
        return fluids.stream().map(fluidStack -> {
            Item bucket = fluidStack.getFluid().m_6859_();
            if (bucket != Items.f_41852_) {
                return bucket.m_7968_();
            }
            return CopperCanItem.setFluid(new ItemStack(TinkerSmeltery.copperCan), fluidStack.getFluid(), null);
        }).toList();
    }
}

