/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.stats;

import java.util.function.Function;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;

public class MaterialStatType<T extends IMaterialStats>
implements IdAwareObject {
    public static final ContextKey<MaterialStatType<?>> CONTEXT_KEY = new ContextKey("material_stat_type");
    private final MaterialStatsId id;
    private final T defaultStats;
    private final RecordLoadable<T> loadable;
    private final boolean canRepair;

    public MaterialStatType(MaterialStatsId id, T defaultStats, RecordLoadable<T> loadable) {
        this.id = id;
        this.defaultStats = defaultStats;
        this.loadable = loadable;
        this.canRepair = defaultStats instanceof IRepairableMaterialStats;
    }

    public MaterialStatType(MaterialStatsId id, Function<MaterialStatType<T>, T> defaultStatsProvider, RecordLoadable<T> loadable) {
        this.id = id;
        this.loadable = loadable;
        this.defaultStats = (IMaterialStats)defaultStatsProvider.apply(this);
        this.canRepair = this.defaultStats instanceof IRepairableMaterialStats;
    }

    public static <T extends IMaterialStats> MaterialStatType<T> singleton(MaterialStatsId id, T instance) {
        return new MaterialStatType<T>(id, instance, new SingletonLoader(instance));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterialStatType that = (MaterialStatType)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public MaterialStatsId getId() {
        return this.id;
    }

    public T getDefaultStats() {
        return this.defaultStats;
    }

    public RecordLoadable<T> getLoadable() {
        return this.loadable;
    }

    public boolean canRepair() {
        return this.canRepair;
    }
}

