/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.block;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;

public record BreakBlockFluidEffect(float hardness, Map<Enchantment, Integer> enchantments) implements FluidEffect<FluidEffectContext.Block>
{
    public static final RecordLoadable<BreakBlockFluidEffect> LOADER = RecordLoadable.create((RecordField)FloatLoadable.FROM_ZERO.defaultField("hardness", (Object)Float.valueOf(0.0f), false, BreakBlockFluidEffect::hardness), (RecordField)Loadables.ENCHANTMENT.mapWithValues((Loadable)IntLoadable.FROM_ONE, 0).defaultField("enchantments", Map.of(), BreakBlockFluidEffect::enchantments), BreakBlockFluidEffect::new);

    public BreakBlockFluidEffect(float hardness) {
        this(hardness, Map.of());
    }

    public BreakBlockFluidEffect(float hardness, Enchantment enchantment, int level) {
        this(hardness, Map.of(enchantment, level));
    }

    @Override
    public RecordLoadable<BreakBlockFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Block context, IFluidHandler.FluidAction action) {
        BlockPos pos;
        BlockState state = context.getBlockState();
        if (state.m_60795_()) {
            return 0.0f;
        }
        Level world = context.getLevel();
        float requirement = state.m_60800_((BlockGetter)world, pos = context.getBlockPos());
        if (requirement < 0.0f) {
            return 0.0f;
        }
        if (context.breakRestricted()) {
            return 0.0f;
        }
        requirement = this.hardness == 0.0f ? 1.0f : (requirement /= this.hardness);
        if (requirement <= level.value()) {
            if (action.execute() && world instanceof ServerLevel) {
                boolean removed;
                ServerLevel server = (ServerLevel)world;
                ItemStack fakeTool = ItemStack.f_41583_;
                if (!this.enchantments.isEmpty()) {
                    fakeTool = new ItemStack((ItemLike)Items.f_42398_);
                    EnchantmentHelper.m_44865_(this.enchantments, (ItemStack)fakeTool);
                }
                BlockEntity te = world.m_7702_(pos);
                Block block = state.m_60734_();
                Player player = context.getPlayer();
                if (player != null) {
                    removed = state.onDestroyedByPlayer(world, pos, player, true, world.m_6425_(pos));
                    if (removed) {
                        player.m_36246_(Stats.f_12949_.m_12902_((Object)block));
                    }
                } else {
                    removed = world.m_7731_(pos, world.m_6425_(pos).m_76188_(), 3);
                }
                if (removed) {
                    state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
                    Projectile source = context.getProjectile();
                    if (source == null) {
                        source = context.getEntity();
                    }
                    LootParams.Builder lootParams = new LootParams.Builder(server).m_287286_(LootContextParams.f_81460_, (Object)context.getHitResult().m_82450_()).m_287286_(LootContextParams.f_81463_, (Object)fakeTool).m_287289_(LootContextParams.f_81462_, (Object)te).m_287289_(LootContextParams.f_81455_, (Object)source);
                    state.m_287290_(lootParams).forEach(stack -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack));
                    state.m_222967_(server, pos, fakeTool, player != null);
                    world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                }
            }
            return requirement;
        }
        return 0.0f;
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        Object translationKey = FluidEffect.getTranslationKey(this.getLoader());
        if (this.enchantments.isEmpty()) {
            if (this.hardness == 0.0f) {
                return Component.m_237115_((String)translationKey);
            }
            return Component.m_237110_((String)((String)translationKey + ".hardness"), (Object[])new Object[]{Float.valueOf(this.hardness)});
        }
        translationKey = (String)translationKey + ".enchanted";
        Component enchantments = this.enchantments().entrySet().stream().map(entry -> {
            Enchantment enchantment = (Enchantment)entry.getKey();
            MutableComponent component = Component.m_237115_((String)enchantment.m_44704_());
            if (enchantment.m_6586_() != 1) {
                component.m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)("enchantment.level." + entry.getValue())));
            }
            return component;
        }).reduce(MERGE_COMPONENT_LIST).orElse((Component)Component.m_237119_());
        if (this.hardness == 0.0f) {
            return Component.m_237110_((String)translationKey, (Object[])new Object[]{enchantments});
        }
        return Component.m_237110_((String)((String)translationKey + ".hardness"), (Object[])new Object[]{Float.valueOf(this.hardness), enchantments});
    }
}

