/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.behavior;

import java.util.Collection;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface MaterialRepairModifierHook {
    public boolean isRepairMaterial(IToolStackView var1, ModifierEntry var2, MaterialId var3);

    public float getRepairAmount(IToolStackView var1, ModifierEntry var2, MaterialId var3);

    public record MaxMerger(Collection<MaterialRepairModifierHook> modules) implements MaterialRepairModifierHook
    {
        @Override
        public boolean isRepairMaterial(IToolStackView tool, ModifierEntry modifier, MaterialId material) {
            for (MaterialRepairModifierHook module : this.modules) {
                if (!module.isRepairMaterial(tool, modifier, material)) continue;
                return true;
            }
            return false;
        }

        @Override
        public float getRepairAmount(IToolStackView tool, ModifierEntry modifier, MaterialId material) {
            float maxRepair = 0.0f;
            for (MaterialRepairModifierHook module : this.modules) {
                float repair = module.getRepairAmount(tool, modifier, material);
                if (!(repair > maxRepair)) continue;
                maxRepair = repair;
            }
            return maxRepair;
        }
    }
}

