/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;

public class BlockTagIngredient
extends AbstractIngredient {
    private final TagKey<Block> tag;
    @Nullable
    private Set<Item> matchingItems;
    @Nullable
    private ItemStack[] items;
    @Nullable
    private IntList stackingIds;

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && this.getMatchingItems().contains(stack.m_41720_());
    }

    public boolean isSimple() {
        return true;
    }

    protected void invalidate() {
        this.matchingItems = null;
        this.items = null;
        this.stackingIds = null;
    }

    private Set<Item> getMatchingItems() {
        if (this.matchingItems == null || this.checkInvalidation()) {
            this.markValid();
            this.matchingItems = RegistryHelper.getTagValueStream((Registry)BuiltInRegistries.f_256975_, this.tag).map(Block::m_5456_).filter(item -> item != Items.f_41852_).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.matchingItems;
    }

    public ItemStack[] m_43908_() {
        if (this.items == null || this.checkInvalidation()) {
            this.markValid();
            this.items = (ItemStack[])this.getMatchingItems().stream().map(ItemStack::new).toArray(ItemStack[]::new);
        }
        return this.items;
    }

    public IntList m_43931_() {
        if (this.stackingIds == null || this.checkInvalidation()) {
            this.markValid();
            Set<Item> items = this.getMatchingItems();
            this.stackingIds = new IntArrayList(items.size());
            for (Item item : items) {
                this.stackingIds.add(BuiltInRegistries.f_257033_.m_7447_((Object)item));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.ID.toString());
        json.add("tag", Loadables.BLOCK_TAG.serialize(this.tag));
        return json;
    }

    public BlockTagIngredient(TagKey<Block> tag) {
        this.tag = tag;
    }

    public static enum Serializer implements IIngredientSerializer<Ingredient>
    {
        INSTANCE;

        public static final ResourceLocation ID;

        public Ingredient parse(JsonObject json) {
            return new BlockTagIngredient((TagKey<Block>)((TagKey)Loadables.BLOCK_TAG.getIfPresent(json, "tag")));
        }

        public void write(FriendlyByteBuf buffer, Ingredient ingredient) {
            buffer.m_236828_(Arrays.asList(ingredient.m_43908_()), FriendlyByteBuf::m_130055_);
        }

        public Ingredient parse(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            return Ingredient.m_43938_(Stream.generate(() -> new Ingredient.ItemValue(buffer.m_130267_())).limit(size));
        }

        static {
            ID = TConstruct.getResource("block_tag");
        }
    }
}

