/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.PlatformBlock;

public class WeatheringPlatformBlock
extends PlatformBlock
implements WeatheringCopper {
    private final WeatheringCopper.WeatherState age;

    public WeatheringPlatformBlock(WeatheringCopper.WeatherState age, BlockBehaviour.Properties props) {
        super(props);
        this.age = age;
    }

    @Override
    protected boolean verticalConnect(BlockState state) {
        return state.m_204336_(TinkerTags.Blocks.COPPER_PLATFORMS);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.m_220947_(pState, pLevel, pPos, pRandom);
    }

    @Nullable
    private static WeatheringCopper.WeatherState getNext(WeatheringCopper.WeatherState original) {
        return switch (original) {
            case WeatheringCopper.WeatherState.UNAFFECTED -> WeatheringCopper.WeatherState.EXPOSED;
            case WeatheringCopper.WeatherState.EXPOSED -> WeatheringCopper.WeatherState.WEATHERED;
            case WeatheringCopper.WeatherState.WEATHERED -> WeatheringCopper.WeatherState.OXIDIZED;
            default -> null;
        };
    }

    public boolean m_6724_(BlockState pState) {
        return WeatheringPlatformBlock.getNext(this.age) != null;
    }

    public Optional<BlockState> m_142123_(BlockState state) {
        return Optional.ofNullable(WeatheringPlatformBlock.getNext(this.age)).map(next -> ((PlatformBlock)((Object)((Object)TinkerCommons.copperPlatform.get((Enum)next)))).m_152465_(state));
    }

    @Nullable
    private static WeatheringCopper.WeatherState getPrevious(WeatheringCopper.WeatherState original) {
        return switch (original) {
            case WeatheringCopper.WeatherState.EXPOSED -> WeatheringCopper.WeatherState.UNAFFECTED;
            case WeatheringCopper.WeatherState.WEATHERED -> WeatheringCopper.WeatherState.EXPOSED;
            case WeatheringCopper.WeatherState.OXIDIZED -> WeatheringCopper.WeatherState.WEATHERED;
            default -> null;
        };
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        WeatheringCopper.WeatherState prev;
        if (ToolActions.AXE_SCRAPE.equals(toolAction) && (prev = WeatheringPlatformBlock.getPrevious(this.age)) != null) {
            return ((PlatformBlock)((Object)TinkerCommons.copperPlatform.get((Enum)prev))).m_152465_(state);
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42784_) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_7731_(pos, ((PlatformBlock)((Object)TinkerCommons.waxedCopperPlatform.get((Enum)this.age))).m_152465_(state), 11);
            level.m_5898_(player, 3003, pos, 0);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.age;
    }
}

