/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.ranged;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public enum RestrictAngleModule implements ModifierModule,
ProjectileLaunchModifierHook
{
    INSTANCE;

    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    public static final SingletonLoader<RestrictAngleModule> LOADER;

    public SingletonLoader<RestrictAngleModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        RestrictAngleModule.clampDirection(projectile.m_20184_(), modifier.getLevel(), projectile);
    }

    public static Vec3 clampDirection(Vec3 direction, int level, @Nullable Projectile projectile) {
        double oldAngle = Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_);
        int possibleDirections = Math.max(4, (int)Math.pow(2.0, 6 - level));
        double radianIncrements = Math.PI * 2 / (double)possibleDirections;
        double newAngle = (double)Math.round(oldAngle / radianIncrements) * radianIncrements;
        direction = direction.m_82524_((float)(newAngle - oldAngle));
        if (projectile != null) {
            projectile.m_20256_(direction);
            projectile.m_146922_((float)(newAngle * 180.0 / Math.PI));
        }
        return direction;
    }

    public static void onKnockback(LivingKnockBackEvent event, int level) {
        Vec3 direction = RestrictAngleModule.clampDirection(new Vec3(event.getRatioX(), 0.0, event.getRatioZ()), level, null);
        event.setRatioX(direction.f_82479_);
        event.setRatioZ(direction.f_82481_);
    }

    static {
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROJECTILE_LAUNCH);
        LOADER = new SingletonLoader((Object)INSTANCE);
    }
}

