/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum IslandPlacement implements StringRepresentable
{
    SKY{

        @Override
        int getHeight(ChunkPos chunkPos, ChunkGenerator generator, LevelHeightAccessor pLevel, Rotation rotation, RandomSource random, RandomState randomState) {
            int xOffset;
            int yOffset = switch (rotation) {
                case Rotation.CLOCKWISE_90 -> {
                    xOffset = -5;
                    yield 5;
                }
                case Rotation.CLOCKWISE_180 -> {
                    xOffset = -5;
                    yield -5;
                }
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    xOffset = 5;
                    yield -5;
                }
                default -> {
                    xOffset = 5;
                    yield 5;
                }
            };
            int x = chunkPos.m_151382_(7);
            int z = chunkPos.m_151391_(7);
            int minXMinZ = generator.m_223235_(x, z, Heightmap.Types.WORLD_SURFACE_WG, pLevel, randomState);
            int minXMaxZ = generator.m_223235_(x, z + yOffset, Heightmap.Types.WORLD_SURFACE_WG, pLevel, randomState);
            int maxXMinZ = generator.m_223235_(x + xOffset, z, Heightmap.Types.WORLD_SURFACE_WG, pLevel, randomState);
            int maxXMaxZ = generator.m_223235_(x + xOffset, z + yOffset, Heightmap.Types.WORLD_SURFACE_WG, pLevel, randomState);
            return Math.min(Math.min(Math.min(minXMinZ, minXMaxZ), Math.min(maxXMinZ, maxXMaxZ)) + 60 + random.m_188503_(50), generator.m_6331_() - 20);
        }
    }
    ,
    SEA{

        @Override
        int getHeight(ChunkPos chunkPos, ChunkGenerator generator, LevelHeightAccessor pLevel, Rotation rotation, RandomSource random, RandomState randomState) {
            return Math.max(generator.m_6337_() - 7, 0);
        }

        @Override
        public boolean isPositionValid(WorldGenLevel world, BlockPos pos, ChunkGenerator generator) {
            BlockPos up = pos.m_7494_();
            if (IslandPlacement.isFluidOrEmpty(world, up)) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (IslandPlacement.isFluidOrEmpty(world, up.m_121945_(direction))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static final Codec<IslandPlacement> CODEC;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);

    private static boolean isFluidOrEmpty(WorldGenLevel world, BlockPos pos) {
        return world.m_46859_(pos) || world.m_8055_(pos).m_60734_() instanceof LiquidBlock;
    }

    public boolean isPositionValid(WorldGenLevel world, BlockPos pos, ChunkGenerator generator) {
        return true;
    }

    abstract int getHeight(ChunkPos var1, ChunkGenerator var2, LevelHeightAccessor var3, Rotation var4, RandomSource var5, RandomState var6);

    public String m_7912_() {
        return this.serializedName;
    }

    static {
        CODEC = StringRepresentable.m_216439_(IslandPlacement::values);
    }
}

