/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnifferEggBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.wanmine.wab.init.world.WabSounds;
import org.jetbrains.annotations.NotNull;

public class BeastEggBlock<T extends LivingEntity>
extends SnifferEggBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0);
    public final Supplier<EntityType<T>> beast;

    public BeastEggBlock(Supplier<EntityType<T>> beast, BlockBehaviour.Properties properties) {
        super(properties.m_60978_(0.5f).m_60918_(SoundType.f_56743_).m_60955_());
        this.beast = beast;
    }

    public void m_213897_(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource source) {
        if (!this.m_276851_(blockState)) {
            level.m_5594_((Player)null, pos, (SoundEvent)WabSounds.EGG_HATCHED.get(), SoundSource.BLOCKS, 0.7f, 0.9f + source.m_188501_() * 0.2f);
            level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)f_278491_, (Comparable)Integer.valueOf(this.m_278758_(blockState) + 1)), 2);
        } else {
            level.m_5594_((Player)null, pos, (SoundEvent)WabSounds.EGG_HATCHED.get(), SoundSource.BLOCKS, 0.7f, 0.9f + source.m_188501_() * 0.2f);
            level.m_46961_(pos, false);
            LivingEntity entity = (LivingEntity)this.beast.get().m_20615_((Level)level);
            if (entity != null) {
                if (entity instanceof AgeableMob) {
                    AgeableMob mob = (AgeableMob)entity;
                    mob.m_6863_(true);
                }
                Vec3 vec3 = pos.m_252807_();
                entity.m_7678_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), Mth.m_14177_((float)(level.f_46441_.m_188501_() * 360.0f)), 0.0f);
                level.m_7967_((Entity)entity);
            }
        }
    }

    private boolean m_276851_(BlockState blockState) {
        return this.m_278758_(blockState) == 2;
    }

    public static class Small<T extends LivingEntity>
    extends BeastEggBlock<T> {
        public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)14.0, (double)13.0);

        public Small(Supplier<EntityType<T>> beast, BlockBehaviour.Properties properties) {
            super(beast, properties);
        }

        @NotNull
        public VoxelShape m_5940_(@NotNull BlockState blockstate, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            return SHAPE;
        }
    }
}

