/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.event;

import java.util.Random;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.wanmine.wab.WanAncientBeasts;
import net.wanmine.wab.capability.AlphaCapability;
import net.wanmine.wab.capability.provider.AlphaProvider;
import net.wanmine.wab.capability.provider.QuickSandProvider;
import net.wanmine.wab.entity.Crusher;
import net.wanmine.wab.entity.Eater;
import net.wanmine.wab.init.data.WabTags;
import net.wanmine.wab.init.data.WabTriggers;
import net.wanmine.wab.init.world.WabEffects;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.item.ReinforcedShield;

@Mod.EventBusSubscriber(modid="wan_ancient_beasts")
public class Entities {
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            if (source instanceof Eater) {
                Eater eater = (Eater)source;
                Random random = new Random();
                if (random.nextInt(99) < 5) {
                    eater.m_19998_((ItemLike)WabItems.EATER_TOOTH.get());
                }
                eater.increaseNomCount();
                if (event.getEntity().m_6095_().m_204039_(WabTags.Entities.ANCIENT_MOBS)) {
                    eater.m_7292_(new MobEffectInstance((MobEffect)WabEffects.ALPHA.get(), 3600));
                }
                if (event.getEntity() instanceof Goat) {
                    WabTriggers.triggerNearby(WabTriggers.NEAR_EATER_KILL_GOAT, (Entity)event.getEntity(), 32);
                }
            }
            if (source.m_21023_((MobEffect)WabEffects.ALPHA.get())) {
                source.getCapability(AlphaProvider.KILL_COUNT).ifPresent(AlphaCapability::increaseKillCount);
            }
        }
    }

    @SubscribeEvent
    public static void getDamage(LivingDamageEvent event) {
        Entity entity;
        Eater eater;
        LivingEntity entity2 = event.getEntity();
        if (entity2 instanceof Eater && (eater = (Eater)entity2).shouldBeSleeping()) {
            eater.setState(Eater.State.WAKE_UP);
        }
        if ((entity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            if (entity2 instanceof Crusher) {
                source.m_6469_(entity2.m_269291_().m_269333_(entity2), 5.0f);
            }
            if (source.m_21023_((MobEffect)WabEffects.ALPHA.get())) {
                source.getCapability(AlphaProvider.KILL_COUNT).ifPresent(alphaCapability -> {
                    if (alphaCapability.getKillCount() > 0) {
                        entity2.m_21153_(entity2.m_21223_() - (float)alphaCapability.getKillCount());
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity attacker;
        LivingEntity entity = event.getEntity();
        if (entity.m_6117_() && entity.m_21211_().m_41720_() instanceof ReinforcedShield && (attacker = event.getSource().m_7639_()) != null && entity.m_146892_().m_82554_(attacker.m_146892_()) < 1.5) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                attacker.m_6469_(player.m_269291_().m_269075_(player), 4.0f);
            } else {
                attacker.m_6469_(entity.m_269291_().m_269333_(entity), 4.0f);
            }
        }
    }

    @SubscribeEvent
    public static void runAway(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)entity;
            if (!(entity instanceof WitherBoss) && !(entity instanceof Eater)) {
                mob.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal(mob, Eater.class, 16.0f, 1.4, 1.5));
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity && !((Entity)event.getObject()).getCapability(AlphaProvider.KILL_COUNT).isPresent()) {
            event.addCapability(WanAncientBeasts.resource("alpha"), (ICapabilityProvider)new AlphaProvider());
            event.addCapability(WanAncientBeasts.resource("quicksand"), (ICapabilityProvider)new QuickSandProvider());
        }
    }
}

