/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.init.world;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.wanmine.wab.block.AncientSkull;
import net.wanmine.wab.block.BeastEggBlock;
import net.wanmine.wab.block.CrusherSpike;
import net.wanmine.wab.block.Nest;
import net.wanmine.wab.block.QuickSand;
import net.wanmine.wab.block.SuspiciousIce;
import net.wanmine.wab.block.entity.AncientSkullEntity;
import net.wanmine.wab.block.entity.SuspiciousIceEntity;
import net.wanmine.wab.entity.Crusher;
import net.wanmine.wab.entity.Eater;
import net.wanmine.wab.entity.Glider;
import net.wanmine.wab.entity.Soarer;
import net.wanmine.wab.entity.Walker;
import net.wanmine.wab.init.world.WabEntities;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.item.AncientSkullItem;

public class WabBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"wan_ancient_beasts");
    public static final RegistryObject<BeastEggBlock<Eater>> EATER_EGG = WabBlocks.registerBlockItem("eater_egg", () -> new BeastEggBlock<Eater>((Supplier<EntityType<Eater>>)WabEntities.EATER, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_)));
    public static final RegistryObject<BeastEggBlock<Walker>> WALKER_EGG = WabBlocks.registerBlockItem("walker_egg", () -> new BeastEggBlock<Walker>((Supplier<EntityType<Walker>>)WabEntities.WALKER, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_)));
    public static final RegistryObject<BeastEggBlock.Small<Crusher>> CRUSHER_EGG = WabBlocks.registerBlockItem("crusher_egg", () -> new BeastEggBlock.Small<Crusher>((Supplier<EntityType<Crusher>>)WabEntities.CRUSHER, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<BeastEggBlock.Small<Glider>> GLIDER_EGG = WabBlocks.registerBlockItem("glider_egg", () -> new BeastEggBlock.Small<Glider>((Supplier<EntityType<Glider>>)WabEntities.GLIDER, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283916_)));
    public static final RegistryObject<BeastEggBlock<Soarer>> SOARER_EGG = WabBlocks.registerBlockItem("soarer_egg", () -> new BeastEggBlock<Soarer>((Supplier<EntityType<Soarer>>)WabEntities.SOARER, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_)));
    public static final RegistryObject<CrusherSpike> CRUSHER_SPIKE = WabBlocks.registerBlockItem("crusher_spike", () -> new CrusherSpike(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_280606_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60955_().m_60918_(SoundType.f_154662_).m_60913_(1.5f, 3.0f).m_60988_().m_278166_(PushReaction.DESTROY).m_60924_(WabBlocks::never)));
    public static final RegistryObject<Nest> NEST = WabBlocks.registerBlockItem("nest", () -> new Nest(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_280658_(NoteBlockInstrument.BASS).m_60978_(0.6f).m_60918_(SoundType.f_222467_).m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> SUSPICIOUS_RED_SAND = WabBlocks.registerBlockItem("suspicious_red_sand", () -> new BrushableBlock(Blocks.f_49993_, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_280658_(NoteBlockInstrument.SNARE).m_60978_(0.25f).m_60918_(SoundType.f_271168_).m_278166_(PushReaction.DESTROY), SoundEvents.f_271174_, SoundEvents.f_271452_));
    public static final RegistryObject<Block> SUSPICIOUS_ICE = WabBlocks.registerBlockItem("suspicious_ice", () -> new SuspiciousIce(Blocks.f_50354_, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283828_).m_280658_(NoteBlockInstrument.CHIME).m_60911_(0.98f).m_60978_(0.25f).m_60918_(SoundType.f_56744_).m_278166_(PushReaction.DESTROY), SoundEvents.f_11985_, SoundEvents.f_11983_));
    public static final RegistryObject<Block> QUICK_SAND = BLOCKS.register("quick_sand", () -> new QuickSand((Supplier<SolidBucketItem>)WabItems.QUICK_SAND_BUCKET, -522861418, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60978_(0.5f).m_60956_(0.4f).m_60918_(SoundType.f_56746_).m_60953_(state -> 8).m_60988_().m_60924_(WabBlocks::never)));
    public static final RegistryObject<Block> QUICK_RED_SAND = BLOCKS.register("quick_red_sand", () -> new QuickSand((Supplier<SolidBucketItem>)WabItems.QUICK_RED_SAND_BUCKET, -525180897, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60978_(0.5f).m_60956_(0.4f).m_60918_(SoundType.f_56746_).m_60953_(state -> 8).m_60988_().m_60924_(WabBlocks::never)));
    public static final RegistryObject<Block> FROZEN_STRAW_BLOCK = WabBlocks.registerBlockItem("frozen_straw_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283828_).m_280658_(NoteBlockInstrument.SNARE).m_60978_(0.6f).m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<Block> STRAW_BLOCK = WabBlocks.registerBlockItem("straw_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_280658_(NoteBlockInstrument.BASS).m_60978_(0.6f).m_60918_(SoundType.f_222467_).m_278183_()));
    public static final RegistryObject<SlabBlock> STRAW_SLAB = WabBlocks.registerBlockItem("straw_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_280658_(NoteBlockInstrument.BASS).m_60978_(0.6f).m_60918_(SoundType.f_222467_).m_278183_()));
    public static final RegistryObject<StairBlock> STRAW_STAIRS = WabBlocks.registerBlockItem("straw_stairs", () -> new StairBlock(() -> ((Block)STRAW_BLOCK.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)STRAW_BLOCK.get()))));
    public static final RegistryObject<AncientSkull> SNIFFER_SKULL = WabBlocks.registerSkull("sniffer_skull", AncientSkull.Type.SNIFFER.name, () -> new AncientSkull(AncientSkull.Type.SNIFFER, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.SKELETON).m_60978_(1.0f).m_278166_(PushReaction.DESTROY).m_60955_()));
    public static final RegistryObject<AncientSkull> EATER_SKULL = WabBlocks.registerSkull("eater_skull", AncientSkull.Type.EATER.name, () -> new AncientSkull(AncientSkull.Type.EATER, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.SKELETON).m_60978_(1.0f).m_278166_(PushReaction.DESTROY).m_60955_()));
    public static final RegistryObject<AncientSkull> WALKER_SKULL = WabBlocks.registerSkull("walker_skull", AncientSkull.Type.WALKER.name, () -> new AncientSkull(AncientSkull.Type.WALKER, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.SKELETON).m_60978_(1.0f).m_278166_(PushReaction.DESTROY).m_60955_()));
    public static final RegistryObject<AncientSkull> CRUSHER_SKULL = WabBlocks.registerSkull("crusher_skull", AncientSkull.Type.CRUSHER.name, () -> new AncientSkull(AncientSkull.Type.CRUSHER, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.SKELETON).m_60978_(1.0f).m_278166_(PushReaction.DESTROY).m_60955_()));
    public static final RegistryObject<AncientSkull> GLIDER_SKULL = WabBlocks.registerSkull("glider_skull", AncientSkull.Type.GLIDER.name, () -> new AncientSkull(AncientSkull.Type.GLIDER, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.SKELETON).m_60978_(1.0f).m_278166_(PushReaction.DESTROY).m_60955_()));
    public static final RegistryObject<AncientSkull> SOARER_SKULL = WabBlocks.registerSkull("soarer_skull", AncientSkull.Type.SOARER.name, () -> new AncientSkull(AncientSkull.Type.SOARER, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.SKELETON).m_60978_(1.0f).m_278166_(PushReaction.DESTROY).m_60955_()));
    public static final RegistryObject<AncientSkull> CHARGER_SKULL = WabBlocks.registerSkull("charger_skull", AncientSkull.Type.CHARGER.name, () -> new AncientSkull(AncientSkull.Type.CHARGER, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.SKELETON).m_60978_(1.0f).m_278166_(PushReaction.DESTROY).m_60955_()));

    private static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    private static boolean always(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    private static <T extends Block> RegistryObject<T> registerBlockItem(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        WabBlocks.registerItem(name, toReturn);
        return toReturn;
    }

    private static RegistryObject<AncientSkull> registerSkull(String name, String skullName, Supplier<AncientSkull> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        WabItems.ITEMS.register(name, () -> new AncientSkullItem((AncientSkull)((Object)((Object)toReturn.get())), skullName, new Item.Properties().m_41487_(1)));
        return toReturn;
    }

    private static <T extends Block> void registerItem(String name, RegistryObject<T> block) {
        WabItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public class Entities {
        public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"wan_ancient_beasts");
        public static final RegistryObject<BlockEntityType<SuspiciousIceEntity>> SUSPICIOUS_ICE = BLOCK_ENTITIES.register("suspicious_ice", () -> BlockEntityType.Builder.m_155273_(SuspiciousIceEntity::new, (Block[])new Block[]{(Block)SUSPICIOUS_ICE.get()}).m_58966_(null));
        public static final RegistryObject<BlockEntityType<AncientSkullEntity>> SNIFFER_SKULL = BLOCK_ENTITIES.register("sniffer_skull", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new AncientSkullEntity(AncientSkull.Type.SNIFFER, pos, state), (Block[])new Block[]{(Block)SNIFFER_SKULL.get()}).m_58966_(null));
        public static final RegistryObject<BlockEntityType<AncientSkullEntity>> EATER_SKULL = BLOCK_ENTITIES.register("eater_skull", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new AncientSkullEntity(AncientSkull.Type.EATER, pos, state), (Block[])new Block[]{(Block)EATER_SKULL.get()}).m_58966_(null));
        public static final RegistryObject<BlockEntityType<AncientSkullEntity>> WALKER_SKULL = BLOCK_ENTITIES.register("walker_skull", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new AncientSkullEntity(AncientSkull.Type.WALKER, pos, state), (Block[])new Block[]{(Block)WALKER_SKULL.get()}).m_58966_(null));
        public static final RegistryObject<BlockEntityType<AncientSkullEntity>> CRUSHER_SKULL = BLOCK_ENTITIES.register("crusher_skull", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new AncientSkullEntity(AncientSkull.Type.CRUSHER, pos, state), (Block[])new Block[]{(Block)CRUSHER_SKULL.get()}).m_58966_(null));
        public static final RegistryObject<BlockEntityType<AncientSkullEntity>> GLIDER_SKULL = BLOCK_ENTITIES.register("glider_skull", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new AncientSkullEntity(AncientSkull.Type.GLIDER, pos, state), (Block[])new Block[]{(Block)GLIDER_SKULL.get()}).m_58966_(null));
        public static final RegistryObject<BlockEntityType<AncientSkullEntity>> SOARER_SKULL = BLOCK_ENTITIES.register("soarer_skull", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new AncientSkullEntity(AncientSkull.Type.SOARER, pos, state), (Block[])new Block[]{(Block)SOARER_SKULL.get()}).m_58966_(null));
        public static final RegistryObject<BlockEntityType<AncientSkullEntity>> CHARGER_SKULL = BLOCK_ENTITIES.register("charger_skull", () -> BlockEntityType.Builder.m_155273_((pos, state) -> new AncientSkullEntity(AncientSkull.Type.CHARGER, pos, state), (Block[])new Block[]{(Block)CHARGER_SKULL.get()}).m_58966_(null));
    }
}

